from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WARFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWARFile");
  exportedObject.put("roleName", "WebSphereWARFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfile.lastmodified", objid, "lastModified","WARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfile.originaluri", objid, "originalURI","WARFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.warfile.types", objid, "types","WARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfile.directoryentry", objid, "directoryEntry","WARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfile.uri", objid, "URI","WARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfile.size", objid, "size","WARFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "WARFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WARFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("WARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.warfile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.warfile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.warfile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.warfile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.warfile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.warfile.size", None));
  print "Creating WARFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WARFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WARFile');

def update(objid,jsonobject):
  Util.pushPathElement('WARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("WARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfile.lastmodified", None), "lastModified","WARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfile.originaluri", None), "originalURI","WARFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.warfile.types", None), "types","WARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfile.directoryentry", None), "directoryEntry","WARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfile.uri", None), "URI","WARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfile.size", None), "size","WARFile");
  if len(atts) != 0:
    print "Modifying WARFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WARFile configuration up to date.";

  File.removeFiles(objid, 'files',"WARFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WARFile');
