from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASDataSourceDefinition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASDataSourceDefinition");
  exportedObject.put("roleName", "WebSphereWASDataSourceDefinition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.initialpoolsize", objid, "initialPoolSize","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.password", objid, "password","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.classname", objid, "className","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.portnumber", objid, "portNumber","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.maxstatements", objid, "maxStatements","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.url", objid, "url","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.servername", objid, "serverName","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.logintimeout", objid, "loginTimeout","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.isolationlevel", objid, "isolationLevel","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.refname", objid, "refName","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.minpoolsize", objid, "minPoolSize","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.maxpoolsize", objid, "maxPoolSize","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.transactional", objid, "transactional","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.databasename", objid, "databaseName","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.maxidletime", objid, "maxIdleTime","WASDataSourceDefinition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinition.user", objid, "user","WASDataSourceDefinition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WASDataSourceDefinition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASDataSourceDefinition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASDataSourceDefinition')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASDataSourceDefinition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "initialPoolSize", roleProperties.optString("websphere.wasdatasourcedefinition.initialpoolsize", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.wasdatasourcedefinition.password", None));
  Util.addIfNotNone(properties, "className", roleProperties.optString("websphere.wasdatasourcedefinition.classname", None));
  Util.addIfNotNone(properties, "portNumber", roleProperties.optString("websphere.wasdatasourcedefinition.portnumber", None));
  Util.addIfNotNone(properties, "maxStatements", roleProperties.optString("websphere.wasdatasourcedefinition.maxstatements", None));
  Util.addIfNotNone(properties, "url", roleProperties.optString("websphere.wasdatasourcedefinition.url", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.wasdatasourcedefinition.servername", None));
  Util.addIfNotNone(properties, "loginTimeout", roleProperties.optString("websphere.wasdatasourcedefinition.logintimeout", None));
  Util.addIfNotNone(properties, "isolationLevel", roleProperties.optString("websphere.wasdatasourcedefinition.isolationlevel", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.wasdatasourcedefinition.refname", None));
  Util.addIfNotNone(properties, "minPoolSize", roleProperties.optString("websphere.wasdatasourcedefinition.minpoolsize", None));
  Util.addIfNotNone(properties, "maxPoolSize", roleProperties.optString("websphere.wasdatasourcedefinition.maxpoolsize", None));
  Util.addIfNotNone(properties, "transactional", roleProperties.optString("websphere.wasdatasourcedefinition.transactional", None));
  Util.addIfNotNone(properties, "databaseName", roleProperties.optString("websphere.wasdatasourcedefinition.databasename", None));
  Util.addIfNotNone(properties, "maxIdleTime", roleProperties.optString("websphere.wasdatasourcedefinition.maxidletime", None));
  Util.addIfNotNone(properties, "user", roleProperties.optString("websphere.wasdatasourcedefinition.user", None));
  print "Creating WASDataSourceDefinition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASDataSourceDefinition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WASDataSourceDefinition');

def update(objid,jsonobject):
  Util.pushPathElement('WASDataSourceDefinition')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASDataSourceDefinition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.initialpoolsize", None), "initialPoolSize","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.password", None), "password","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.classname", None), "className","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.portnumber", None), "portNumber","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.maxstatements", None), "maxStatements","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.url", None), "url","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.servername", None), "serverName","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.logintimeout", None), "loginTimeout","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.isolationlevel", None), "isolationLevel","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.refname", None), "refName","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.minpoolsize", None), "minPoolSize","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.maxpoolsize", None), "maxPoolSize","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.transactional", None), "transactional","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.databasename", None), "databaseName","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.maxidletime", None), "maxIdleTime","WASDataSourceDefinition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinition.user", None), "user","WASDataSourceDefinition");
  if len(atts) != 0:
    print "Modifying WASDataSourceDefinition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASDataSourceDefinition configuration up to date.";

  Property.removeProperties(objid, 'properties',"WASDataSourceDefinition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WASDataSourceDefinition');
