from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WLMCoreGroupBridgePlugin import WLMCoreGroupBridgePlugin;
from utilities import Util
from Property import Property

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  containmentpath = "%(parentconpath)sCoreGroupBridgeSettings:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, "Core Group Bridge Settings");
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CoreGroupBridgeSettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCoreGroupBridgeSettings");
  exportedObject.put("roleName", "WebSphereCoreGroupBridgeSettings");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CoreGroupBridgeSettings");
  i = 0;
  plugins = Util.parseConfigIdListAttribute(objid, 'wlmCoreGroupBridgePlugins', "CoreGroupBridgeSettings");
  for plugin in plugins:
    if len(plugin) > 0:
      returndict = Util.createTypeFolder(respath, "WLMCoreGroupBridgePlugin", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, WLMCoreGroupBridgePlugin._export(plugin, currespath, "WLMCoreGroupBridgePlugin%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CoreGroupBridgeSettings');
  return result;


def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupBridgeSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create CoreGroupBridgeSettings on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('CoreGroupBridgeSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupBridgeSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating CoreGroupBridgeSettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CoreGroupBridgeSettings", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereWLMCoreGroupBridgePlugin":
          WLMCoreGroupBridgePlugin.create(objid, curjsonobject);
  Util.popPathElement('CoreGroupBridgeSettings');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('CoreGroupBridgeSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupBridgeSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying CoreGroupBridgeSettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CoreGroupBridgeSettings configuration up to date.";

  Property.removeProperties(objid, 'properties',"CoreGroupBridgeSettings");

  plugins = Util.parseConfigIdListAttribute(objid, 'wlmCoreGroupBridgePlugins', "CoreGroupBridgeSettings");
  for plugin in plugins:
    Util.remove(plugin);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereWLMCoreGroupBridgePlugin":
          WLMCoreGroupBridgePlugin.create(objid, curjsonobject);
  Util.popPathElement('CoreGroupBridgeSettings');
