from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBGatewayLink')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBGatewayLink");
  exportedObject.put("roleName", "WebSphereSIBGatewayLink");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.uuid", objid, "uuid","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.name", objid, "name","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.protocolname", objid, "protocolName","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.initialstate", objid, "initialState","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.targetuuid", objid, "targetUuid","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.remotemessagingenginename", objid, "remoteMessagingEngineName","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.description", objid, "description","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.bootstrapendpoints", objid, "bootstrapEndpoints","SIBGatewayLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibgatewaylink.authalias", objid, "authAlias","SIBGatewayLink");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBGatewayLink');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBGatewayLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBGatewayLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibgatewaylink.uuid", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibgatewaylink.name", None));
  Util.addIfNotNone(properties, "protocolName", roleProperties.optString("websphere.sibgatewaylink.protocolname", None));
  Util.addIfNotNone(properties, "initialState", roleProperties.optString("websphere.sibgatewaylink.initialstate", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibgatewaylink.targetuuid", None));
  Util.addIfNotNone(properties, "remoteMessagingEngineName", roleProperties.optString("websphere.sibgatewaylink.remotemessagingenginename", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibgatewaylink.description", None));
  Util.addIfNotNone(properties, "bootstrapEndpoints", roleProperties.optString("websphere.sibgatewaylink.bootstrapendpoints", None));
  Util.addIfNotNone(properties, "authAlias", roleProperties.optString("websphere.sibgatewaylink.authalias", None));
  print "Creating SIBGatewayLink with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBGatewayLink", parentid, properties);
  Util.popPathElement('SIBGatewayLink');

def update(objid,jsonobject):
  Util.pushPathElement('SIBGatewayLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBGatewayLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.uuid", None), "uuid","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.name", None), "name","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.protocolname", None), "protocolName","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.initialstate", None), "initialState","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.targetuuid", None), "targetUuid","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.remotemessagingenginename", None), "remoteMessagingEngineName","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.description", None), "description","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.bootstrapendpoints", None), "bootstrapEndpoints","SIBGatewayLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibgatewaylink.authalias", None), "authAlias","SIBGatewayLink");
  if len(atts) != 0:
    print "Modifying SIBGatewayLink with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBGatewayLink configuration up to date.";

  Util.popPathElement('SIBGatewayLink');
