from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBJMSQueueConnectionFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBJMSQueueConnectionFactory");
  exportedObject.put("roleName", "WebSphereSIBJMSQueueConnectionFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.clientid", objid, "clientId","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.servername", objid, "serverName","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.name", objid, "name","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.category", objid, "category","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.providertype", objid, "providerType","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.jndiname", objid, "jndiName","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.readahead", objid, "readAhead","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.busname", objid, "busName","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.menames", objid, "meNames","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.tempqueuemodelname", objid, "tempQueueModelName","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.nonpersistentmapping", objid, "nonPersistentMapping","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.username", objid, "userName","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.password", objid, "password","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.description", objid, "description","SIBJMSQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueueconnectionfactory.portnumber", objid, "portNumber","SIBJMSQueueConnectionFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBJMSQueueConnectionFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBJMSQueueConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSQueueConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "clientId", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.clientid", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.servername", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.jndiname", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.readahead", None));
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.busname", None));
  Util.addIfNotNone(properties, "meNames", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.menames", None));
  Util.addIfNotNone(properties, "tempQueueModelName", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.tempqueuemodelname", None));
  Util.addIfNotNone(properties, "nonPersistentMapping", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.nonpersistentmapping", None));
  Util.addIfNotNone(properties, "userName", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.username", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.password", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.description", None));
  Util.addIfNotNone(properties, "portNumber", roleProperties.optString("websphere.sibjmsqueueconnectionfactory.portnumber", None));
  print "Creating SIBJMSQueueConnectionFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBJMSQueueConnectionFactory", parentid, properties);
  Util.popPathElement('SIBJMSQueueConnectionFactory');

def update(objid,jsonobject):
  Util.pushPathElement('SIBJMSQueueConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSQueueConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.clientid", None), "clientId","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.servername", None), "serverName","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.name", None), "name","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.category", None), "category","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.providertype", None), "providerType","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.jndiname", None), "jndiName","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.readahead", None), "readAhead","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.busname", None), "busName","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.menames", None), "meNames","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.tempqueuemodelname", None), "tempQueueModelName","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.nonpersistentmapping", None), "nonPersistentMapping","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.username", None), "userName","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.password", None), "password","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.description", None), "description","SIBJMSQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueueconnectionfactory.portnumber", None), "portNumber","SIBJMSQueueConnectionFactory");
  if len(atts) != 0:
    print "Modifying SIBJMSQueueConnectionFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBJMSQueueConnectionFactory configuration up to date.";

  Util.popPathElement('SIBJMSQueueConnectionFactory');
