from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.Timestamp')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonext.Timestamp");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonext.Timestamp");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.timestamp.expires", objid, "expires","com.ibm.etools.webservice.wscommonext.Timestamp");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.timestamp.keyword", objid, "keyword","com.ibm.etools.webservice.wscommonext.Timestamp");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.timestamp.dialect", objid, "Dialect","com.ibm.etools.webservice.wscommonext.Timestamp");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.timestamp.name", objid, "name","com.ibm.etools.webservice.wscommonext.Timestamp");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonext.Timestamp');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.Timestamp')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonext.Timestamp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "expires", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.expires", None));
  Util.addIfNotNone(properties, "keyword", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.keyword", None));
  Util.addIfNotNone(properties, "Dialect", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.dialect", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.name", None));
  print "Creating com.ibm.etools.webservice.wscommonext.Timestamp with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonext.Timestamp", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonext.Timestamp');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.Timestamp')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonext.Timestamp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.expires", None), "expires","com.ibm.etools.webservice.wscommonext.Timestamp");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.keyword", None), "keyword","com.ibm.etools.webservice.wscommonext.Timestamp");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.dialect", None), "Dialect","com.ibm.etools.webservice.wscommonext.Timestamp");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.timestamp.name", None), "name","com.ibm.etools.webservice.wscommonext.Timestamp");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonext.Timestamp with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonext.Timestamp configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonext.Timestamp');
