from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

################################################################
### When implemented, verify WAS 7 -> WAS 9 migration works! ###
################################################################

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LooseApplication')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLooseApplication");
  exportedObject.put("roleName", "WebSphereLooseApplication");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looseapplication.archiveversion", objid, "archiveVersion","LooseApplication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looseapplication.archivetype", objid, "archiveType","LooseApplication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looseapplication.uri", objid, "uri","LooseApplication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looseapplication.binariespath", objid, "binariesPath","LooseApplication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looseapplication.resourcespath", objid, "resourcesPath","LooseApplication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.looseapplication.otherarchivetype", objid, "otherArchiveType","LooseApplication");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"LooseApplication");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LooseApplication');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LooseApplication')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseApplication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "archiveVersion", roleProperties.optString("websphere.looseapplication.archiveversion", ""));
  Util.addIfNotNone(properties, "archiveType", roleProperties.optString("websphere.looseapplication.archivetype", ""));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.looseapplication.uri", None));
  Util.addIfNotNone(properties, "binariesPath", roleProperties.optString("websphere.looseapplication.binariespath", None));
  Util.addIfNotNone(properties, "resourcesPath", roleProperties.optString("websphere.looseapplication.resourcespath", None));
  Util.addIfNotNone(properties, "otherArchiveType", roleProperties.optString("websphere.looseapplication.otherarchivetype", ""));
  print "Creating LooseApplication with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LooseApplication", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseApplication');

def update(objid,jsonobject):
  Util.pushPathElement('LooseApplication')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseApplication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looseapplication.archiveversion", ""), "archiveVersion","LooseApplication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looseapplication.archivetype", ""), "archiveType","LooseApplication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looseapplication.uri", None), "uri","LooseApplication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looseapplication.binariespath", None), "binariesPath","LooseApplication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looseapplication.resourcespath", None), "resourcesPath","LooseApplication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.looseapplication.otherarchivetype", ""), "otherArchiveType","LooseApplication");
  if len(atts) != 0:
    print "Modifying LooseApplication with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LooseApplication configuration up to date.";

  Property.removeProperties(objid, 'properties',"LooseApplication");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseApplication');
