from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StandAloneApplicationServerMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStandAloneApplicationServerMapping");
  exportedObject.put("roleName", "WebSphereStandAloneApplicationServerMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.standaloneapplicationservermapping.applicationname", objid, "applicationName","StandAloneApplicationServerMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.standaloneapplicationservermapping.cellname", objid, "cellName","StandAloneApplicationServerMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.standaloneapplicationservermapping.transportchain", objid, "transportChain","StandAloneApplicationServerMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.standaloneapplicationservermapping.servername", objid, "serverName","StandAloneApplicationServerMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.standaloneapplicationservermapping.nodename", objid, "nodeName","StandAloneApplicationServerMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StandAloneApplicationServerMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StandAloneApplicationServerMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("StandAloneApplicationServerMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "applicationName", roleProperties.optString("websphere.standaloneapplicationservermapping.applicationname", None));
  Util.addIfNotNone(properties, "cellName", roleProperties.optString("websphere.standaloneapplicationservermapping.cellname", None));
  Util.addIfNotNone(properties, "transportChain", roleProperties.optString("websphere.standaloneapplicationservermapping.transportchain", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.standaloneapplicationservermapping.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.standaloneapplicationservermapping.nodename", None));
  print "Creating StandAloneApplicationServerMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StandAloneApplicationServerMapping", parentid, properties);
  Util.popPathElement('StandAloneApplicationServerMapping');

def update(objid,jsonobject):
  Util.pushPathElement('StandAloneApplicationServerMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("StandAloneApplicationServerMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.standaloneapplicationservermapping.applicationname", None), "applicationName","StandAloneApplicationServerMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.standaloneapplicationservermapping.cellname", None), "cellName","StandAloneApplicationServerMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.standaloneapplicationservermapping.transportchain", None), "transportChain","StandAloneApplicationServerMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.standaloneapplicationservermapping.servername", None), "serverName","StandAloneApplicationServerMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.standaloneapplicationservermapping.nodename", None), "nodeName","StandAloneApplicationServerMapping");
  if len(atts) != 0:
    print "Modifying StandAloneApplicationServerMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StandAloneApplicationServerMapping configuration up to date.";

  Util.popPathElement('StandAloneApplicationServerMapping');
