from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransportLayer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransportLayer");
  exportedObject.put("roleName", "WebSphereTransportLayer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transportlayer.useclaim", objid, "useClaim","TransportLayer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransportLayer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TransportLayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportLayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "useClaim", roleProperties.optString("websphere.transportlayer.useclaim", None));
  print "Creating TransportLayer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransportLayer", parentid, properties);
  Util.popPathElement('TransportLayer');

def update(objid,jsonobject):
  Util.pushPathElement('TransportLayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportLayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transportlayer.useclaim", None), "useClaim","TransportLayer");
  if len(atts) != 0:
    print "Modifying TransportLayer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransportLayer configuration up to date.";

  Util.popPathElement('TransportLayer');
