from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StormDrainCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStormDrainCondition");
  exportedObject.put("roleName", "WebSphereStormDrainCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stormdraincondition.name", objid, "name","StormDrainCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stormdraincondition.conditionexpr", objid, "conditionExpr","StormDrainCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stormdraincondition.level", objid, "level","StormDrainCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StormDrainCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StormDrainCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("StormDrainCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.stormdraincondition.name", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.stormdraincondition.conditionexpr", None));
  Util.addIfNotNone(properties, "level", roleProperties.optString("websphere.stormdraincondition.level", None));
  print "Creating StormDrainCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StormDrainCondition", parentid, properties);
  Util.popPathElement('StormDrainCondition');

def update(objid,jsonobject):
  Util.pushPathElement('StormDrainCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("StormDrainCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stormdraincondition.name", None), "name","StormDrainCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stormdraincondition.conditionexpr", None), "conditionExpr","StormDrainCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stormdraincondition.level", None), "level","StormDrainCondition");
  if len(atts) != 0:
    print "Modifying StormDrainCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StormDrainCondition configuration up to date.";

  Util.popPathElement('StormDrainCondition');

def getStormDrainCondition(objid):
  stormDrainCondition = Util.getAssociatedObjects(objid, "StormDrainCondition");
  return stormDrainCondition;
