from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSNService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSNService");
  exportedObject.put("roleName", "WebSphereWSNService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.outboundsecurityconfigname", objid, "outboundSecurityConfigName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.sibdestination", objid, "sibDestination","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.notificationbrokerservicename", objid, "notificationBrokerServiceName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.type", objid, "type","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.version", objid, "version","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.outboundsecurityresponsebindingname", objid, "outboundSecurityResponseBindingName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.topicexpressiondialects", objid, "topicExpressionDialects","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.outboundsecurityrequestbindingname", objid, "outboundSecurityRequestBindingName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.querywsdl", objid, "queryWSDL","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.dynamictopicspace", objid, "dynamicTopicSpace","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.subscriptionmanagerservicename", objid, "subscriptionManagerServiceName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.permitsdynamictopicnamespace", objid, "permitsDynamicTopicNamespace","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.jaxwshandlerlist", objid, "jaxwsHandlerList","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.description", objid, "description","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.uuid", objid, "uuid","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.pubregmanagerservicename", objid, "pubRegManagerServiceName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.usesfixedtopicset", objid, "usesFixedTopicSet","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.jaxrpchandlerlistname", objid, "jaxrpcHandlerListName","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.requiresregistration", objid, "requiresRegistration","WSNService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnservice.name", objid, "name","WSNService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"WSNService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSNService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSNService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "outboundSecurityConfigName", roleProperties.optString("websphere.wsnservice.outboundsecurityconfigname", None));
  Util.addIfNotNone(properties, "sibDestination", roleProperties.optString("websphere.wsnservice.sibdestination", None));
  Util.addIfNotNone(properties, "notificationBrokerServiceName", roleProperties.optString("websphere.wsnservice.notificationbrokerservicename", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.wsnservice.type", None));
  Util.addIfNotNone(properties, "version", roleProperties.optString("websphere.wsnservice.version", None));
  Util.addIfNotNone(properties, "outboundSecurityResponseBindingName", roleProperties.optString("websphere.wsnservice.outboundsecurityresponsebindingname", None));
  Util.addIfNotNone(properties, "topicExpressionDialects", roleProperties.optString("websphere.wsnservice.topicexpressiondialects", None));
  Util.addIfNotNone(properties, "outboundSecurityRequestBindingName", roleProperties.optString("websphere.wsnservice.outboundsecurityrequestbindingname", None));
  Util.addIfNotNone(properties, "queryWSDL", roleProperties.optString("websphere.wsnservice.querywsdl", None));
  Util.addIfNotNone(properties, "dynamicTopicSpace", roleProperties.optString("websphere.wsnservice.dynamictopicspace", None));
  Util.addIfNotNone(properties, "subscriptionManagerServiceName", roleProperties.optString("websphere.wsnservice.subscriptionmanagerservicename", None));
  Util.addIfNotNone(properties, "permitsDynamicTopicNamespace", roleProperties.optString("websphere.wsnservice.permitsdynamictopicnamespace", None));
  Util.addIfNotNone(properties, "jaxwsHandlerList", roleProperties.optString("websphere.wsnservice.jaxwshandlerlist", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsnservice.description", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.wsnservice.uuid", None));
  Util.addIfNotNone(properties, "pubRegManagerServiceName", roleProperties.optString("websphere.wsnservice.pubregmanagerservicename", None));
  Util.addIfNotNone(properties, "usesFixedTopicSet", roleProperties.optString("websphere.wsnservice.usesfixedtopicset", None));
  Util.addIfNotNone(properties, "jaxrpcHandlerListName", roleProperties.optString("websphere.wsnservice.jaxrpchandlerlistname", None));
  Util.addIfNotNone(properties, "requiresRegistration", roleProperties.optString("websphere.wsnservice.requiresregistration", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsnservice.name", None));
  print "Creating WSNService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSNService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNService');

def update(objid,jsonobject):
  Util.pushPathElement('WSNService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.outboundsecurityconfigname", None), "outboundSecurityConfigName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.sibdestination", None), "sibDestination","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.notificationbrokerservicename", None), "notificationBrokerServiceName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.type", None), "type","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.version", None), "version","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.outboundsecurityresponsebindingname", None), "outboundSecurityResponseBindingName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.topicexpressiondialects", None), "topicExpressionDialects","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.outboundsecurityrequestbindingname", None), "outboundSecurityRequestBindingName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.querywsdl", None), "queryWSDL","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.dynamictopicspace", None), "dynamicTopicSpace","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.subscriptionmanagerservicename", None), "subscriptionManagerServiceName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.permitsdynamictopicnamespace", None), "permitsDynamicTopicNamespace","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.jaxwshandlerlist", None), "jaxwsHandlerList","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.description", None), "description","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.uuid", None), "uuid","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.pubregmanagerservicename", None), "pubRegManagerServiceName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.usesfixedtopicset", None), "usesFixedTopicSet","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.jaxrpchandlerlistname", None), "jaxrpcHandlerListName","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.requiresregistration", None), "requiresRegistration","WSNService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnservice.name", None), "name","WSNService");
  if len(atts) != 0:
    print "Modifying WSNService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSNService configuration up to date.";

  Property.removeProperties(objid, 'property',"WSNService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNService');
