from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.LoginBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscbnd.LoginBinding");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscbnd.LoginBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.loginbinding.callbackhandler", objid, "callbackHandler","com.ibm.etools.webservice.wscbnd.LoginBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.loginbinding.authmethod", objid, "authMethod","com.ibm.etools.webservice.wscbnd.LoginBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"com.ibm.etools.webservice.wscbnd.LoginBinding");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.LoginBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.LoginBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.LoginBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "callbackHandler", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.loginbinding.callbackhandler", None));
  Util.addIfNotNone(properties, "authMethod", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.loginbinding.authmethod", None));
  print "Creating com.ibm.etools.webservice.wscbnd.LoginBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscbnd.LoginBinding", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.LoginBinding');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.LoginBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.LoginBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.loginbinding.callbackhandler", None), "callbackHandler","com.ibm.etools.webservice.wscbnd.LoginBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.loginbinding.authmethod", None), "authMethod","com.ibm.etools.webservice.wscbnd.LoginBinding");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscbnd.LoginBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscbnd.LoginBinding configuration up to date.";

  Property.removeProperties(objid, 'properties',"com.ibm.etools.webservice.wscbnd.LoginBinding");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.LoginBinding');
