from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthBrowser import SIBAuthBrowser;
from SIBAuthCreator import SIBAuthCreator;
from SIBAuthIdentityAdopter import SIBAuthIdentityAdopter;
from SIBAuthReceiver import SIBAuthReceiver;
from SIBAuthSender import SIBAuthSender;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthPort')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthPort");
  exportedObject.put("roleName", "WebSphereSIBAuthPort");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthport.inheritdefaults", objid, "inheritDefaults","SIBAuthPort");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthport.identifier", objid, "identifier","SIBAuthPort");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  browser = Util.getOptionalAttribute(objid, 'browser', 'SIBAuthPort');
  if browser is not None and len(browser) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthBrowser", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthBrowser._export(browser, currespath, "SIBAuthBrowser"));

  creator = Util.getOptionalAttribute(objid, 'creator', 'SIBAuthPort');
  if creator is not None and len(creator) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthCreator", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthCreator._export(creator, currespath, "SIBAuthCreator"));

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthPort');
  if identityAdopter is not None and len(identityAdopter) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthIdentityAdopter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthIdentityAdopter._export(identityAdopter, currespath, "SIBAuthIdentityAdopter"));

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthPort');
  if receiver is not None and len(receiver) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthReceiver", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthReceiver._export(receiver, currespath, "SIBAuthReceiver"));

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthPort');
  if sender is not None and len(sender) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthSender", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthSender._export(sender, currespath, "SIBAuthSender"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthPort');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritDefaults", roleProperties.optString("websphere.sibauthport.inheritdefaults", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthport.identifier", None));
  print "Creating SIBAuthPort with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthPort", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthBrowser":
        SIBAuthBrowser.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthCreator":
        SIBAuthCreator.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthPort');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthPort')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthPort resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthport.inheritdefaults", None), "inheritDefaults","SIBAuthPort");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthport.identifier", None), "identifier","SIBAuthPort");
  if len(atts) != 0:
    print "Modifying SIBAuthPort with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthPort configuration up to date.";

  browser = Util.getOptionalAttribute(objid, 'browser', 'SIBAuthPort');
  if browser is not None and len(browser) > 0:
    Util.remove(browser);

  creator = Util.getOptionalAttribute(objid, 'creator', 'SIBAuthPort');
  if creator is not None and len(creator) > 0:
    Util.remove(creator);

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthPort');
  if identityAdopter is not None and len(identityAdopter) > 0:
    Util.remove(identityAdopter);

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthPort');
  if receiver is not None and len(receiver) > 0:
    Util.remove(receiver);

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthPort');
  if sender is not None and len(sender) > 0:
    Util.remove(sender);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthBrowser":
        SIBAuthBrowser.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthCreator":
        SIBAuthCreator.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthPort');
