from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StaticCacheRule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStaticCacheRule");
  exportedObject.put("roleName", "WebSphereStaticCacheRule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.staticcacherule.virtualhostname", objid, "virtualHostName","StaticCacheRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.staticcacherule.nocache", objid, "noCache","StaticCacheRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.staticcacherule.defaultexpiration", objid, "defaultExpiration","StaticCacheRule");
  # Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.staticcacherule.lastmodifiedfactor", objid, "lastModifiedFactor","StaticCacheRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.staticcacherule.urigroup", objid, "uriGroup","StaticCacheRule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"StaticCacheRule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StaticCacheRule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StaticCacheRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("StaticCacheRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "virtualHostName", roleProperties.optString("websphere.staticcacherule.virtualhostname", None));
  Util.addIfNotNone(properties, "noCache", roleProperties.optString("websphere.staticcacherule.nocache", None));
  Util.addIfNotNone(properties, "defaultExpiration", roleProperties.optString("websphere.staticcacherule.defaultexpiration", None));
  # Util.addIfNotNone(properties, "lastModifiedFactor", roleProperties.optString("websphere.staticcacherule.lastmodifiedfactor", None));
  Util.addIfNotNone(properties, "uriGroup", roleProperties.optString("websphere.staticcacherule.urigroup", None));
  print "Creating StaticCacheRule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StaticCacheRule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('StaticCacheRule');

def update(objid,jsonobject):
  Util.pushPathElement('StaticCacheRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("StaticCacheRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.staticcacherule.virtualhostname", None), "virtualHostName","StaticCacheRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.staticcacherule.nocache", None), "noCache","StaticCacheRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.staticcacherule.defaultexpiration", None), "defaultExpiration","StaticCacheRule");
  # Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.staticcacherule.lastmodifiedfactor", None), "lastModifiedFactor","StaticCacheRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.staticcacherule.urigroup", None), "uriGroup","StaticCacheRule");
  if len(atts) != 0:
    print "Modifying StaticCacheRule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StaticCacheRule configuration up to date.";

  Property.removeProperties(objid, 'properties',"StaticCacheRule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('StaticCacheRule');
