from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.RequiredSecurityToken')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonext.RequiredSecurityToken");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.localname", objid, "localName","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.name", objid, "name","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.uri", objid, "uri","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.usage", objid, "usage","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonext.RequiredSecurityToken');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.RequiredSecurityToken')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonext.RequiredSecurityToken resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "localName", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.localname", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.name", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.uri", None));
  Util.addIfNotNone(properties, "usage", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.usage", None));
  print "Creating com.ibm.etools.webservice.wscommonext.RequiredSecurityToken with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonext.RequiredSecurityToken", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonext.RequiredSecurityToken');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.RequiredSecurityToken')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonext.RequiredSecurityToken resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.localname", None), "localName","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.name", None), "name","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.uri", None), "uri","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.requiredsecuritytoken.usage", None), "usage","com.ibm.etools.webservice.wscommonext.RequiredSecurityToken");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonext.RequiredSecurityToken with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonext.RequiredSecurityToken configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonext.RequiredSecurityToken');
