from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPDomainVersion')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPDomainVersion");
  exportedObject.put("roleName", "WebSphereDPDomainVersion");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdomainversion.versionimagefilelocation", objid, "versionImageFileLocation","DPDomainVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdomainversion.versionnumber", objid, "versionNumber","DPDomainVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdomainversion.usercomment", objid, "userComment","DPDomainVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdomainversion.timecreatedinmanager", objid, "timeCreatedInManager","DPDomainVersion");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPDomainVersion");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPDomainVersion');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPDomainVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPDomainVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "versionImageFileLocation", roleProperties.optString("websphere.dpdomainversion.versionimagefilelocation", None));
  Util.addIfNotNone(properties, "versionNumber", roleProperties.optString("websphere.dpdomainversion.versionnumber", None));
  Util.addIfNotNone(properties, "userComment", roleProperties.optString("websphere.dpdomainversion.usercomment", None));
  Util.addIfNotNone(properties, "timeCreatedInManager", roleProperties.optString("websphere.dpdomainversion.timecreatedinmanager", None));
  print "Creating DPDomainVersion with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPDomainVersion", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPDomainVersion');

def update(objid,jsonobject):
  Util.pushPathElement('DPDomainVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPDomainVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdomainversion.versionimagefilelocation", None), "versionImageFileLocation","DPDomainVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdomainversion.versionnumber", None), "versionNumber","DPDomainVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdomainversion.usercomment", None), "userComment","DPDomainVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdomainversion.timecreatedinmanager", None), "timeCreatedInManager","DPDomainVersion");
  if len(atts) != 0:
    print "Modifying DPDomainVersion with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPDomainVersion configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPDomainVersion");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPDomainVersion');
