from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LooseWARFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLooseWARFile");
  exportedObject.put("roleName", "WebSphereLooseWARFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.archiveversion", objid, "archiveVersion","LooseWARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.archivetype", objid, "archiveType","LooseWARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.uri", objid, "uri","LooseWARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.binariespath", objid, "binariesPath","LooseWARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.resourcespath", objid, "resourcesPath","LooseWARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.otherarchivetype", objid, "otherArchiveType","LooseWARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosewarfile.altdd", objid, "altDD","LooseWARFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"LooseWARFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LooseWARFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LooseWARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseWARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "archiveVersion", roleProperties.optString("websphere.loosewarfile.archiveversion", ""));
  Util.addIfNotNone(properties, "archiveType", roleProperties.optString("websphere.loosewarfile.archivetype", "OTHER"));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.loosewarfile.uri", None));
  Util.addIfNotNone(properties, "binariesPath", roleProperties.optString("websphere.loosewarfile.binariespath", None));
  Util.addIfNotNone(properties, "resourcesPath", roleProperties.optString("websphere.loosewarfile.resourcespath", None));
  Util.addIfNotNone(properties, "otherArchiveType", roleProperties.optString("websphere.loosewarfile.otherarchivetype", ""));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.loosewarfile.altdd", None));
  print "Creating LooseWARFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LooseWARFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseWARFile');

def update(objid,jsonobject):
  Util.pushPathElement('LooseWARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseWARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.archiveversion", ""), "archiveVersion","LooseWARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.archivetype", "OTHER"), "archiveType","LooseWARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.uri", None), "uri","LooseWARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.binariespath", None), "binariesPath","LooseWARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.resourcespath", None), "resourcesPath","LooseWARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.otherarchivetype", ""), "otherArchiveType","LooseWARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosewarfile.altdd", None), "altDD","LooseWARFile");
  if len(atts) != 0:
    print "Modifying LooseWARFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LooseWARFile configuration up to date.";

  Property.removeProperties(objid, 'properties',"LooseWARFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('LooseWARFile');
