from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBMediationInstance import SIBMediationInstance

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMediationExecutionPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMediationExecutionPoint");
  exportedObject.put("roleName", "WebSphereSIBMediationExecutionPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationexecutionpoint.identifier", objid, "identifier","SIBMediationExecutionPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationexecutionpoint.uuid", objid, "uuid","SIBMediationExecutionPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationexecutionpoint.targetuuid", objid, "targetUuid","SIBMediationExecutionPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  mediationInstance = Util.getOptionalAttribute(objid, 'mediationInstance', "SIBMediationExecutionPoint");
  if (mediationInstance is not None) and (len(mediationInstance) > 0):
    returndict = Util.createTypeFolder(respath, "SIBMediationInstance", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBMediationInstance._export(mediationInstance, currespath, "SIBMediationInstance"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMediationExecutionPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMediationExecutionPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediationExecutionPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibmediationexecutionpoint.identifier", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmediationexecutionpoint.uuid", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibmediationexecutionpoint.targetuuid", None));
  print "Creating SIBMediationExecutionPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMediationExecutionPoint", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMediationInstance":
        SIBMediationInstance.create(objid, curjsonobject);
  Util.popPathElement('SIBMediationExecutionPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMediationExecutionPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediationExecutionPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationexecutionpoint.identifier", None), "identifier","SIBMediationExecutionPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationexecutionpoint.uuid", None), "uuid","SIBMediationExecutionPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationexecutionpoint.targetuuid", None), "targetUuid","SIBMediationExecutionPoint");
  if len(atts) != 0:
    print "Modifying SIBMediationExecutionPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMediationExecutionPoint configuration up to date.";

  mediationInstance = Util.getOptionalAttribute(objid, 'mediationInstance', "SIBMediationExecutionPoint");
  if (mediationInstance is not None) and (len(mediationInstance) > 0):
    Util.remove(mediationInstance);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMediationInstance":
        SIBMediationInstance.create(objid, curjsonobject);

  Util.popPathElement('SIBMediationExecutionPoint');
