from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ServerIdentity')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServerIdentity");
  exportedObject.put("roleName", "WebSphereServerIdentity");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serveridentity.serverid", objid, "serverId","ServerIdentity");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServerIdentity');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ServerIdentity')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerIdentity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "serverId", roleProperties.optString("websphere.serveridentity.serverid", None));
  print "Creating ServerIdentity with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServerIdentity", parentid, properties);
  Util.popPathElement('ServerIdentity');

def update(objid,jsonobject):
  Util.pushPathElement('ServerIdentity')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerIdentity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serveridentity.serverid", None), "serverId","ServerIdentity");
  if len(atts) != 0:
    print "Modifying ServerIdentity with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServerIdentity configuration up to date.";

  Util.popPathElement('ServerIdentity');
