from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CustomConditionTemplate')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomConditionTemplate");
  exportedObject.put("roleName", "WebSphereCustomConditionTemplate");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customconditiontemplate.conditionexpression", objid, "conditionExpression","CustomConditionTemplate");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customconditiontemplate.name", objid, "name","CustomConditionTemplate");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomConditionTemplate');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CustomConditionTemplate')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomConditionTemplate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "conditionExpression", roleProperties.optString("websphere.customconditiontemplate.conditionexpression", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.customconditiontemplate.name", None));
  print "Creating CustomConditionTemplate with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomConditionTemplate", parentid, properties);
  Util.popPathElement('CustomConditionTemplate');

def update(objid,jsonobject):
  Util.pushPathElement('CustomConditionTemplate')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomConditionTemplate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customconditiontemplate.conditionexpression", None), "conditionExpression","CustomConditionTemplate");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customconditiontemplate.name", None), "name","CustomConditionTemplate");
  if len(atts) != 0:
    print "Modifying CustomConditionTemplate with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomConditionTemplate configuration up to date.";

  Util.popPathElement('CustomConditionTemplate');
