from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DeploymentTargetMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDeploymentTargetMapping");
  exportedObject.put("roleName", "WebSphereDeploymentTargetMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deploymenttargetmapping.enable", objid, "enable","DeploymentTargetMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DeploymentTargetMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DeploymentTargetMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeploymentTargetMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.deploymenttargetmapping.enable", None));
  print "Creating DeploymentTargetMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DeploymentTargetMapping", parentid, properties);
  Util.popPathElement('DeploymentTargetMapping');

def update(objid,jsonobject):
  Util.pushPathElement('DeploymentTargetMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeploymentTargetMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deploymenttargetmapping.enable", None), "enable","DeploymentTargetMapping");
  if len(atts) != 0:
    print "Modifying DeploymentTargetMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DeploymentTargetMapping configuration up to date.";

  Util.popPathElement('DeploymentTargetMapping');
