from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExternalFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExternalFile");
  exportedObject.put("roleName", "WebSphereExternalFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalfile.hostname", objid, "hostname","ExternalFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalfile.filepath", objid, "filePath","ExternalFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalfile.readonly", objid, "readOnly","ExternalFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExternalFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ExternalFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "hostname", roleProperties.optString("websphere.externalfile.hostname", None));
  Util.addIfNotNone(properties, "filePath", roleProperties.optString("websphere.externalfile.filepath", None));
  Util.addIfNotNone(properties, "readOnly", roleProperties.optString("websphere.externalfile.readonly", None));
  print "Creating ExternalFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExternalFile", parentid, properties);
  Util.popPathElement('ExternalFile');

def update(objid,jsonobject):
  Util.pushPathElement('ExternalFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalfile.hostname", None), "hostname","ExternalFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalfile.filepath", None), "filePath","ExternalFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalfile.readonly", None), "readOnly","ExternalFile");
  if len(atts) != 0:
    print "Modifying ExternalFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExternalFile configuration up to date.";

  Util.popPathElement('ExternalFile');
