from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GridScheduler')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGridScheduler");
  exportedObject.put("roleName", "WebSphereGridScheduler");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.enableusagerecordingzos", objid, "enableUsageRecordingZOS","GridScheduler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.enableusagerecording", objid, "enableUsageRecording","GridScheduler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.deploymenttarget", objid, "deploymentTarget","GridScheduler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.databaseschemaname", objid, "databaseSchemaName","GridScheduler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.datasourcejndiname", objid, "datasourceJNDIName","GridScheduler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.datasourcealias", objid, "datasourceAlias","GridScheduler");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridscheduler.endpointjobloglocation", objid, "endpointJobLogLocation","GridScheduler");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"GridScheduler");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GridScheduler');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GridScheduler')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridScheduler resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableUsageRecordingZOS", roleProperties.optString("websphere.gridscheduler.enableusagerecordingzos", None));
  Util.addIfNotNone(properties, "enableUsageRecording", roleProperties.optString("websphere.gridscheduler.enableusagerecording", None));
  Util.addIfNotNone(properties, "deploymentTarget", roleProperties.optString("websphere.gridscheduler.deploymenttarget", None));
  Util.addIfNotNone(properties, "databaseSchemaName", roleProperties.optString("websphere.gridscheduler.databaseschemaname", None));
  Util.addIfNotNone(properties, "datasourceJNDIName", roleProperties.optString("websphere.gridscheduler.datasourcejndiname", None));
  Util.addIfNotNone(properties, "datasourceAlias", roleProperties.optString("websphere.gridscheduler.datasourcealias", None));
  Util.addIfNotNone(properties, "endpointJobLogLocation", roleProperties.optString("websphere.gridscheduler.endpointjobloglocation", None));
  print "Creating GridScheduler with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GridScheduler", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GridScheduler');

def update(objid,jsonobject):
  Util.pushPathElement('GridScheduler')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridScheduler resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.enableusagerecordingzos", None), "enableUsageRecordingZOS","GridScheduler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.enableusagerecording", None), "enableUsageRecording","GridScheduler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.deploymenttarget", None), "deploymentTarget","GridScheduler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.databaseschemaname", None), "databaseSchemaName","GridScheduler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.datasourcejndiname", None), "datasourceJNDIName","GridScheduler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.datasourcealias", None), "datasourceAlias","GridScheduler");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridscheduler.endpointjobloglocation", None), "endpointJobLogLocation","GridScheduler");
  if len(atts) != 0:
    print "Modifying GridScheduler with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GridScheduler configuration up to date.";

  Property.removeProperties(objid, 'properties',"GridScheduler");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GridScheduler');
