from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('IdentityAssertionLayer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIdentityAssertionLayer");
  exportedObject.put("roleName", "WebSphereIdentityAssertionLayer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identityassertionlayer.useclaim", objid, "useClaim","IdentityAssertionLayer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('IdentityAssertionLayer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('IdentityAssertionLayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("IdentityAssertionLayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "useClaim", roleProperties.optString("websphere.identityassertionlayer.useclaim", None));
  print "Creating IdentityAssertionLayer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("IdentityAssertionLayer", parentid, properties);
  Util.popPathElement('IdentityAssertionLayer');

def update(objid,jsonobject):
  Util.pushPathElement('IdentityAssertionLayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("IdentityAssertionLayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identityassertionlayer.useclaim", None), "useClaim","IdentityAssertionLayer");
  if len(atts) != 0:
    print "Modifying IdentityAssertionLayer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "IdentityAssertionLayer configuration up to date.";

  Util.popPathElement('IdentityAssertionLayer');
