from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ORBPlugin')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereORBPlugin");
  exportedObject.put("roleName", "WebSphereORBPlugin");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.orbplugin.name", objid, "name","ORBPlugin");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ORBPlugin');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ORBPlugin')
  if not jsonobject.has("roleProperties"):
    raise Exception("ORBPlugin resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.orbplugin.name", None));
  print "Creating ORBPlugin with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ORBPlugin", parentid, properties);
  Util.popPathElement('ORBPlugin');

def update(objid,jsonobject):
  Util.pushPathElement('ORBPlugin')
  if not jsonobject.has("roleProperties"):
    raise Exception("ORBPlugin resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.orbplugin.name", None), "name","ORBPlugin");
  if len(atts) != 0:
    print "Modifying ORBPlugin with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ORBPlugin configuration up to date.";

  Util.popPathElement('ORBPlugin');
