from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from CustomErrorPagePolicy import CustomErrorPagePolicy
from LocalErrorPagePolicy import LocalErrorPagePolicy
from StaticFileServingPolicy import StaticFileServingPolicy

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProxyVirtualHostSettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProxyVirtualHostSettings");
  exportedObject.put("roleName", "WebSphereProxyVirtualHostSettings");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.enablelogging", objid, "enableLogging","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.localaccesslog", objid, "localAccessLog","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.useserverloggingsettings", objid, "useServerLoggingSettings","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.proxyaccesslog", objid, "proxyAccessLog","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.useserverstaticfilesettings", objid, "useServerStaticFileSettings","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.useservererrorpagesettings", objid, "useServerErrorPageSettings","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.cacheaccesslog", objid, "cacheAccessLog","ProxyVirtualHostSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyvirtualhostsettings.maximumlogsize", objid, "maximumLogSize","ProxyVirtualHostSettings");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  customErrorPagePolicy = Util.getOptionalAttribute(objid, 'errorPagePolicy',"ProxyVirtualHostSettings");
  if customErrorPagePolicy is not None and len(customErrorPagePolicy) > 0:
    returndict = Util.createTypeFolder(respath, "CustomErrorPagePolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, CustomErrorPagePolicy._export(customErrorPagePolicy, currespath, "Custom Error Page Policy"));

  localErrorPagePolicy = Util.getOptionalAttribute(objid, 'localErrorPagePolicy',"ProxyVirtualHostSettings");
  if localErrorPagePolicy is not None and len(localErrorPagePolicy) > 0:
    returndict = Util.createTypeFolder(respath, "LocalErrorPagePolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, LocalErrorPagePolicy._export(localErrorPagePolicy, currespath, "Local Error Page Policy"));

  staticFileServingPolicy = Util.getOptionalAttribute(objid, 'staticFileServingPolicy',"ProxyVirtualHostSettings");
  if staticFileServingPolicy is not None and len(staticFileServingPolicy) > 0:
    returndict = Util.createTypeFolder(respath, "StaticFileServingPolicy", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StaticFileServingPolicy._export(staticFileServingPolicy, currespath, "Static File Serving Policy"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProxyVirtualHostSettings');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProxyVirtualHostSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyVirtualHostSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableLogging", roleProperties.optString("websphere.proxyvirtualhostsettings.enablelogging", None));
  Util.addIfNotNone(properties, "localAccessLog", roleProperties.optString("websphere.proxyvirtualhostsettings.localaccesslog", None));
  Util.addIfNotNone(properties, "useServerLoggingSettings", roleProperties.optString("websphere.proxyvirtualhostsettings.useserverloggingsettings", None));
  Util.addIfNotNone(properties, "proxyAccessLog", roleProperties.optString("websphere.proxyvirtualhostsettings.proxyaccesslog", None));
  Util.addIfNotNone(properties, "useServerStaticFileSettings", roleProperties.optString("websphere.proxyvirtualhostsettings.useserverstaticfilesettings", None));
  Util.addIfNotNone(properties, "useServerErrorPageSettings", roleProperties.optString("websphere.proxyvirtualhostsettings.useservererrorpagesettings", None));
  Util.addIfNotNone(properties, "cacheAccessLog", roleProperties.optString("websphere.proxyvirtualhostsettings.cacheaccesslog", None));
  Util.addIfNotNone(properties, "maximumLogSize", roleProperties.optString("websphere.proxyvirtualhostsettings.maximumlogsize", None));
  print "Creating ProxyVirtualHostSettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProxyVirtualHostSettings", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereCustomErrorPagePolicy":
        CustomErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereLocalErrorPagePolicy":
        LocalErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereStaticFileServingPolicy":
        StaticFileServingPolicy.create(objid, curjsonobject);
  Util.popPathElement('ProxyVirtualHostSettings');

def update(objid,jsonobject):
  Util.pushPathElement('ProxyVirtualHostSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyVirtualHostSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.enablelogging", None), "enableLogging","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.localaccesslog", None), "localAccessLog","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.useserverloggingsettings", None), "useServerLoggingSettings","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.proxyaccesslog", None), "proxyAccessLog","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.useserverstaticfilesettings", None), "useServerStaticFileSettings","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.useservererrorpagesettings", None), "useServerErrorPageSettings","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.cacheaccesslog", None), "cacheAccessLog","ProxyVirtualHostSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyvirtualhostsettings.maximumlogsize", None), "maximumLogSize","ProxyVirtualHostSettings");
  if len(atts) != 0:
    print "Modifying ProxyVirtualHostSettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProxyVirtualHostSettings configuration up to date.";

  customErrorPagePolicy = Util.getOptionalAttribute(objid, 'errorPagePolicy',"ProxyVirtualHostSettings");
  if customErrorPagePolicy is not None and len(customErrorPagePolicy) > 0:
    Util.remove(customErrorPagePolicy);

  localErrorPagePolicy = Util.getOptionalAttribute(objid, 'localErrorPagePolicy',"ProxyVirtualHostSettings");
  if localErrorPagePolicy is not None and len(localErrorPagePolicy) > 0:
    Util.remove(localErrorPagePolicy);

  staticFileServingPolicy = Util.getOptionalAttribute(objid, 'staticFileServingPolicy',"ProxyVirtualHostSettings");
  if staticFileServingPolicy is not None and len(staticFileServingPolicy) > 0:
    Util.remove(staticFileServingPolicy);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereCustomErrorPagePolicy":
        CustomErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereLocalErrorPagePolicy":
        LocalErrorPagePolicy.create(objid, curjsonobject);
      elif currole == "WebSphereStaticFileServingPolicy":
        StaticFileServingPolicy.create(objid, curjsonobject);
  Util.popPathElement('ProxyVirtualHostSettings');
