from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBPSBTopicTransactionality import SIBPSBTopicTransactionality

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBPSBTopicMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBPSBTopicMapping");
  exportedObject.put("roleName", "WebSphereSIBPSBTopicMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopicmapping.topicspace", objid, "topicSpace","SIBPSBTopicMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopicmapping.topicname", objid, "topicName","SIBPSBTopicMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopicmapping.brokerstreamqueue", objid, "brokerStreamQueue","SIBPSBTopicMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopicmapping.direction", objid, "direction","SIBPSBTopicMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopicmapping.subscriptionpoint", objid, "subscriptionPoint","SIBPSBTopicMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  transactionality = Util.getOptionalAttribute(objid, 'transactionality', "SIBPSBTopicMapping");
  if (transactionality is not None) and (len(transactionality) > 0):
    returndict = Util.createTypeFolder(respath, "SIBPSBTopicTransactionality", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBPSBTopicTransactionality._export(transactionality, currespath, "SIBPSBTopicTransactionality"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBPSBTopicMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBPSBTopicMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBTopicMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "topicSpace", roleProperties.optString("websphere.sibpsbtopicmapping.topicspace", None));
  Util.addIfNotNone(properties, "topicName", roleProperties.optString("websphere.sibpsbtopicmapping.topicname", None));
  Util.addIfNotNone(properties, "brokerStreamQueue", roleProperties.optString("websphere.sibpsbtopicmapping.brokerstreamqueue", None));
  Util.addIfNotNone(properties, "direction", roleProperties.optString("websphere.sibpsbtopicmapping.direction", None));
  Util.addIfNotNone(properties, "subscriptionPoint", roleProperties.optString("websphere.sibpsbtopicmapping.subscriptionpoint", None));
  print "Creating SIBPSBTopicMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBPSBTopicMapping", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBPSBTopicTransactionality":
        SIBPSBTopicTransactionality.create(objid, curjsonobject);
  Util.popPathElement('SIBPSBTopicMapping');

def update(objid,jsonobject):
  Util.pushPathElement('SIBPSBTopicMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBTopicMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopicmapping.topicspace", None), "topicSpace","SIBPSBTopicMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopicmapping.topicname", None), "topicName","SIBPSBTopicMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopicmapping.brokerstreamqueue", None), "brokerStreamQueue","SIBPSBTopicMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopicmapping.direction", None), "direction","SIBPSBTopicMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopicmapping.subscriptionpoint", None), "subscriptionPoint","SIBPSBTopicMapping");
  if len(atts) != 0:
    print "Modifying SIBPSBTopicMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBPSBTopicMapping configuration up to date.";

  transactionality = Util.getOptionalAttribute(objid, 'transactionality', "SIBPSBTopicMapping");
  if (transactionality is not None) and (len(transactionality) > 0):
    Util.remove(transactionality);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBPSBTopicTransactionality":
        SIBPSBTopicTransactionality.create(objid, curjsonobject);

  Util.popPathElement('SIBPSBTopicMapping');
