from org.codehaus.jettison.json import JSONObject, JSONArray
from utilities import Util
from VisualizationDataLog import VisualizationDataLog

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('VisualizationDataService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereVisualizationDataService");
  exportedObject.put("roleName", "WebSphereVisualizationDataService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdataservice.enable", objid, "enable","VisualizationDataService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];

  typeFolders = {};
  visualizationDataLog = Util.getOptionalAttribute(objid, 'visualizationDataLog', 'VisualizationDataService');
  if visualizationDataLog is not None and len(visualizationDataLog) > 0:
    returndict = Util.createTypeFolder(respath, 'VisualizationDataLog', typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, VisualizationDataLog._export(visualizationDataLog, currespath, "VisualizationDataService"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('VisualizationDataService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('VisualizationDataService')
  if not jsonobject.has("roleProperties"):
    raise Exception("VisualizationDataService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.visualizationdataservice.enable", None));
  print "Creating VisualizationDataService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("VisualizationDataService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereVisualizationDataLog":
        VisualizationDataLog.create(objid, curjsonobject);
  Util.popPathElement('VisualizationDataService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('VisualizationDataService')
  if not jsonobject.has("roleProperties"):
    raise Exception("VisualizationDataService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdataservice.enable", None), "enable","VisualizationDataService");
  if len(atts) != 0:
    print "Modifying VisualizationDataService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "VisualizationDataService configuration up to date.";

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereVisualizationDataLog":
        VisualizationDataLog.update(objid, curjsonobject);

  Util.popPathElement('VisualizationDataService');
