from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.wastopic.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WASTopic');

  containmentpath = "%(parentconpath)sWASTopic:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WASTopic')

  name = Util.getRequiredAttribute(objid, "name", 'WASTopic');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASTopic");
  exportedObject.put("roleName", "WebSphereWASTopic");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.name", objid, "name","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.category", objid, "category","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.expiry", objid, "expiry","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.providertype", objid, "providerType","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.topic", objid, "topic","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.jndiname", objid, "jndiName","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.specifiedpriority", objid, "specifiedPriority","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.specifiedexpiry", objid, "specifiedExpiry","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.persistence", objid, "persistence","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.priority", objid, "priority","WASTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wastopic.description", objid, "description","WASTopic");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASTopic');
  return result;


def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);


def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WASTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.wastopic.name"):
    raise Exception("Resource role properties does not contain websphere.wastopic.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create WASTopic on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WASTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.wastopic.name"):
    raise Exception("Resource role properties does not contain websphere.wastopic.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wastopic.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.wastopic.category", None));
  Util.addIfNotNone(properties, "expiry", roleProperties.optString("websphere.wastopic.expiry", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.wastopic.providertype", None));
  Util.addIfNotNone(properties, "topic", roleProperties.optString("websphere.wastopic.topic", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.wastopic.jndiname", None));
  Util.addIfNotNone(properties, "specifiedPriority", roleProperties.optString("websphere.wastopic.specifiedpriority", None));
  Util.addIfNotNone(properties, "specifiedExpiry", roleProperties.optString("websphere.wastopic.specifiedexpiry", None));
  Util.addIfNotNone(properties, "persistence", roleProperties.optString("websphere.wastopic.persistence", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.wastopic.priority", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wastopic.description", None));
  print "Creating WASTopic with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASTopic", parentid, properties);
  Util.popPathElement('WASTopic');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WASTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.wastopic.name"):
    raise Exception("Resource role properties does not contain websphere.wastopic.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.name", None), "name","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.category", None), "category","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.expiry", None), "expiry","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.providertype", None), "providerType","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.topic", None), "topic","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.jndiname", None), "jndiName","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.specifiedpriority", None), "specifiedPriority","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.specifiedexpiry", None), "specifiedExpiry","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.persistence", None), "persistence","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.priority", None), "priority","WASTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wastopic.description", None), "description","WASTopic");
  if len(atts) != 0:
    print "Modifying WASTopic with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASTopic configuration up to date.";

  Util.popPathElement('WASTopic');
