from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.genericjmsdestination.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'GenericJMSDestination');

  containmentpath = "%(parentconpath)sGenericJMSDestination:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('GenericJMSDestination')

  name = Util.getRequiredAttribute(objid, "name", 'GenericJMSDestination');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericJMSDestination");
  exportedObject.put("roleName", "WebSphereGenericJMSDestination");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.name", objid, "name","GenericJMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.category", objid, "category","GenericJMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.providertype", objid, "providerType","GenericJMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.jndiname", objid, "jndiName","GenericJMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.type", objid, "type","GenericJMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.externaljndiname", objid, "externalJNDIName","GenericJMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericjmsdestination.description", objid, "description","GenericJMSDestination");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericJMSDestination');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericJMSDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.genericjmsdestination.name"):
    raise Exception("Resource role properties does not contain websphere.genericjmsdestination.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create GenericJMSDestination on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericJMSDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericJMSDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.genericjmsdestination.name"):
    raise Exception("Resource role properties does not contain websphere.genericjmsdestination.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.genericjmsdestination.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.genericjmsdestination.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.genericjmsdestination.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.genericjmsdestination.jndiname", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.genericjmsdestination.type", None));
  Util.addIfNotNone(properties, "externalJNDIName", roleProperties.optString("websphere.genericjmsdestination.externaljndiname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.genericjmsdestination.description", None));
  print "Creating GenericJMSDestination with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericJMSDestination", parentid, properties);
  Util.popPathElement('GenericJMSDestination');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('GenericJMSDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericJMSDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.genericjmsdestination.name"):
    raise Exception("Resource role properties does not contain websphere.genericjmsdestination.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.name", None), "name","GenericJMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.category", None), "category","GenericJMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.providertype", None), "providerType","GenericJMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.jndiname", None), "jndiName","GenericJMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.type", None), "type","GenericJMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.externaljndiname", None), "externalJNDIName","GenericJMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericjmsdestination.description", None), "description","GenericJMSDestination");
  if len(atts) != 0:
    print "Modifying GenericJMSDestination with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericJMSDestination configuration up to date.";

  Util.popPathElement('GenericJMSDestination');
