from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Liveness')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLiveness");
  exportedObject.put("roleName", "WebSphereLiveness");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.liveness.discoveryperiod", objid, "discoveryPeriod","Liveness");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.liveness.heartbeattransmissionperiod", objid, "heartbeatTransmissionPeriod","Liveness");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.liveness.heartbeattimeoutperiod", objid, "heartbeatTimeoutPeriod","Liveness");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.liveness.livenesstype", objid, "livenessType","Liveness");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.liveness.factoryclassname", objid, "factoryClassName","Liveness");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid,respath,extraObjects,typeFolders,'customProperties',"Liveness");

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Liveness');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Liveness')
  if not jsonobject.has("roleProperties"):
    raise Exception("Liveness resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "discoveryPeriod", roleProperties.optString("websphere.liveness.discoveryperiod", None));
  Util.addIfNotNone(properties, "heartbeatTransmissionPeriod", roleProperties.optString("websphere.liveness.heartbeattransmissionperiod", None));
  Util.addIfNotNone(properties, "heartbeatTimeoutPeriod", roleProperties.optString("websphere.liveness.heartbeattimeoutperiod", None));
  Util.addIfNotNone(properties, "livenessType", roleProperties.optString("websphere.liveness.livenesstype", None));
  Util.addIfNotNone(properties, "factoryClassName", roleProperties.optString("websphere.liveness.factoryclassname", None));
  print "Creating Liveness with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Liveness", parentid, properties);

  Property.removeProperties(objid, 'customProperties',"Liveness");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Liveness');

def update(objid,jsonobject):
  Util.pushPathElement('Liveness')
  if not jsonobject.has("roleProperties"):
    raise Exception("Liveness resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.liveness.discoveryperiod", None), "discoveryPeriod","Liveness");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.liveness.heartbeattransmissionperiod", None), "heartbeatTransmissionPeriod","Liveness");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.liveness.heartbeattimeoutperiod", None), "heartbeatTimeoutPeriod","Liveness");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.liveness.livenesstype", None), "livenessType","Liveness");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.liveness.factoryclassname", None), "factoryClassName","Liveness");
  if len(atts) != 0:
    print "Modifying Liveness with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Liveness configuration up to date.";

  Property.removeProperties(objid, 'customProperties',"Liveness");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Liveness');
