from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MultibrokerDomain')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMultibrokerDomain");
  exportedObject.put("roleName", "WebSphereMultibrokerDomain");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.multibrokerdomain.name", objid, "name","MultibrokerDomain");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MultibrokerDomain');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MultibrokerDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("MultibrokerDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.multibrokerdomain.name", None));
  print "Creating MultibrokerDomain with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MultibrokerDomain", parentid, properties);
  Util.popPathElement('MultibrokerDomain');

def update(objid,jsonobject):
  Util.pushPathElement('MultibrokerDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("MultibrokerDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.multibrokerdomain.name", None), "name","MultibrokerDomain");
  if len(atts) != 0:
    print "Modifying MultibrokerDomain with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MultibrokerDomain configuration up to date.";

  Util.popPathElement('MultibrokerDomain');
