from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log
from EndPoint import EndPoint
from OverlayEndpoint import OverlayEndpoint
from Interceptor import Interceptor
from LSDConnection import LSDConnection
from ORBPlugin import ORBPlugin
from ThreadPool import ThreadPool
from utilities import Util
from Property import Property

__name_att__ = None;

def createEndPoint(objid, curjsonobject, attName):
  endpointhost = "";
  endpointport = "";
  if curjsonobject.getString("roleName") == "WebSphereOverlayEndpoint":
    endpointport = curjsonobject.getJSONObject("roleProperties").getString("websphere.overlayendpoint.port");
    endpointhost = curjsonobject.getJSONObject("roleProperties").getString("websphere.overlayendpoint.host");
    newVal = '[["port" "%(port)s"] ["host" "%(host)s"]]' % { 'port': endpointport, 'host':endpointhost };
    Log.debug("Updating %(att)s on ORB with val %(val)s" %{ 'att': attName, 'val': newVal });
    Util.modify(objid, [[attName, newVal]]);
  elif curjsonobject.getString("roleName") == "WebSphereEndPoint":
    endpointport = curjsonobject.getJSONObject("roleProperties").getString("websphere.endpoint.port");
    endpointhost = curjsonobject.getJSONObject("roleProperties").getString("websphere.endpoint.host");
    newVal = '[["port" "%(port)s"] ["host" "%(host)s"]]' % { 'port': endpointport, 'host':endpointhost };
    Util.modify(objid, [[attName, newVal]]);

def exportEndpoint(extraObjects, typeFolders, respath, objid, attName, coerceToOverlays):
  Log.debug("Trying to export EndPoint from ORB with att name %s" % attName);
  endpoint = Util.getOptionalAttribute(objid, attName, 'ObjectRequestBroker');
  if endpoint is not None and len(endpoint) > 1:
    Log.debug("Found export EndPoint from ORB with obj id %s" % endpoint);
    if endpoint.find("#EndPoint_") != 1:
      if coerceToOverlays == 1:
        returndict = Util.createTypeFolder(respath, "OverlayEndpoint", typeFolders);
        currespath = returndict['path'];
        if returndict.has_key('object'):
          Util.addFromExport(extraObjects, returndict['object']);
        Util.addAllFromExport(extraObjects, OverlayEndpoint._export(endpoint, currespath, attName, 0));
      else:
        returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
        currespath = returndict['path'];
        if returndict.has_key('object'):
          Util.addFromExport(extraObjects, returndict['object']);
        Util.addAllFromExport(extraObjects, EndPoint._export(endpoint, currespath, attName));
    else:
      returndict = Util.createTypeFolder(respath, "OverlayEndpoint", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, OverlayEndpoint._export(endpoint, currespath, attName, 1));

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ObjectRequestBroker')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereObjectRequestBroker");
  exportedObject.put("roleName", "WebSphereObjectRequestBroker");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.locaterequesttimeout", objid, "locateRequestTimeout","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.forcetunnel", objid, "forceTunnel","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.nolocalcopies", objid, "noLocalCopies","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.requestretriescount", objid, "requestRetriesCount","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.enable", objid, "enable","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.connectioncacheminimum", objid, "connectionCacheMinimum","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.connectioncachemaximum", objid, "connectionCacheMaximum","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.requestretriesdelay", objid, "requestRetriesDelay","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.commtraceenabled", objid, "commTraceEnabled","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.tunnelagenturl", objid, "tunnelAgentURL","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.useserverthreadpool", objid, "useServerThreadPool","ObjectRequestBroker");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectrequestbroker.requesttimeout", objid, "requestTimeout","ObjectRequestBroker");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ObjectRequestBroker");

  i = 0;
  interceptors = Util.parseConfigIdListAttribute(objid, 'interceptors', 'ObjectRequestBroker');
  #Sorting is needed in an attempt to keep the same order for the Interceptors when doing a resource tree compare.
  interceptors.sort();
  for interceptor in interceptors:
    if len(interceptor) > 0:
      returndict = Util.createTypeFolder(respath, "Interceptor", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Interceptor._export(interceptor, currespath, "Interceptor%s" % i));
      i = i + 1;

  lsdConnection = Util.getOptionalAttribute(objid, 'lsdConnection', 'ObjectRequestBroker');
  if lsdConnection is not None and len(lsdConnection) > 0:
    returndict = Util.createTypeFolder(respath, "LSDConnection", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, LSDConnection._export(lsdConnection, currespath, 'LSDConnection'));

  i = 0;
  plugins = Util.parseConfigIdListAttribute(objid, 'plugins',"ObjectRequestBroker");
  for plugin in plugins:
    if len(plugin) > 0:
      returndict = Util.createTypeFolder(respath, "ORBPlugin", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ORBPlugin._export(plugin, currespath, "ORBPlugin%s" % i));
      i = i + 1;

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'ObjectRequestBroker');
  if threadPool is not None and len(threadPool) > 0:
    returndict = Util.createTypeFolder(respath, "ThreadPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ThreadPool._export(threadPool, currespath));

  #newer websphere will only allow use to create OverlayEndpoints on ORB. Older versions dont even have overlay endpoints.
  #applying Endpoints to orb always uses the modify command... thanks WebSphere
  coerceToOverlay = 0;
  #if Util.isValidType("OverlayEndpoint"):
    #coerceToOverlay = 1;

  exportEndpoint(extraObjects, typeFolders, respath, objid, 'CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS', coerceToOverlay);
  exportEndpoint(extraObjects, typeFolders, respath, objid, 'CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS', coerceToOverlay);
  exportEndpoint(extraObjects, typeFolders, respath, objid, 'ORB_LISTENER_ADDRESS', coerceToOverlay);
  exportEndpoint(extraObjects, typeFolders, respath, objid, 'SAS_SSL_SERVERAUTH_LISTENER_ADDRESS', coerceToOverlay);

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ObjectRequestBroker');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ObjectRequestBroker')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectRequestBroker resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "locateRequestTimeout", roleProperties.optString("websphere.objectrequestbroker.locaterequesttimeout", None));
  Util.addIfNotNone(properties, "forceTunnel", roleProperties.optString("websphere.objectrequestbroker.forcetunnel", None));
  Util.addIfNotNone(properties, "noLocalCopies", roleProperties.optString("websphere.objectrequestbroker.nolocalcopies", None));
  Util.addIfNotNone(properties, "requestRetriesCount", roleProperties.optString("websphere.objectrequestbroker.requestretriescount", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.objectrequestbroker.enable", None));
  Util.addIfNotNone(properties, "connectionCacheMinimum", roleProperties.optString("websphere.objectrequestbroker.connectioncacheminimum", None));
  Util.addIfNotNone(properties, "connectionCacheMaximum", roleProperties.optString("websphere.objectrequestbroker.connectioncachemaximum", None));
  Util.addIfNotNone(properties, "requestRetriesDelay", roleProperties.optString("websphere.objectrequestbroker.requestretriesdelay", None));
  Util.addIfNotNone(properties, "commTraceEnabled", roleProperties.optString("websphere.objectrequestbroker.commtraceenabled", None));
  Util.addIfNotNone(properties, "tunnelAgentURL", roleProperties.optString("websphere.objectrequestbroker.tunnelagenturl", None));
  Util.addIfNotNone(properties, "useServerThreadPool", roleProperties.optString("websphere.objectrequestbroker.useserverthreadpool", None));
  Util.addIfNotNone(properties, "requestTimeout", roleProperties.optString("websphere.objectrequestbroker.requesttimeout", None));
  print "Creating ObjectRequestBroker with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ObjectRequestBroker", parentid, properties);

  Property.removeProperties(objid, 'properties',"ObjectRequestBroker");

  interceptors = Util.parseConfigIdListAttribute(objid, 'interceptors',"ObjectRequestBroker");
  for interceptor in interceptors:
    if len(interceptor) > 0:
      Util.remove(interceptor);

  lsdConnection = Util.getOptionalAttribute(objid, 'lsdConnection', 'ObjectRequestBroker');
  if lsdConnection is not None and len(lsdConnection) > 0:
    Util.remove(lsdConnection);

  plugins = Util.parseConfigIdListAttribute(objid, 'plugins',"ObjectRequestBroker");
  for plugin in plugins:
    if len(plugin) > 0:
      Util.remove(plugin);

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'ObjectRequestBroker');
  if threadPool is not None and len(threadPool) > 0:
    Util.remove(threadPool);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereInterceptor":
          Interceptor.create(objid, curjsonobject);
        elif currole == "WebSphereLSDConnection":
          LSDConnection.create(objid, curjsonobject);
        elif currole == "WebSphereORBPlugin":
          ORBPlugin.create(objid, curjsonobject);
        elif currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
        elif currole == "WebSphereEndPoint":
          name = curjsonobject.getString('name');
          if name == "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject)
            else:
              createEndPoint(objid, curjsonobject, "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
          elif name == "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject);
            else:
              createEndPoint(objid, curjsonobject, "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
          elif name == "ORB_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'ORB_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject);
            else:
              createEndPoint(objid, curjsonobject, "ORB_LISTENER_ADDRESS");
          elif name == "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'SAS_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject);
            else:
              createEndPoint(objid, curjsonobject, "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS");
          else:
            Log.log("Warning: Invalid attribute name " + name + " specified for WebSphereEndPoint. Expected " +
            "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS, CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS, " +
            "ORB_LISTENER_ADDRESS or SAS_SSL_SERVERAUTH_LISTENER_ADDRESS.");
        '''
        ITS NOT POSSIBLE FROM WHAT I CAN TELL
        elif currole == "WebSphereOverlayEndpoint":
          name = curjsonobject.getString('name');
          if name == "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")
          elif name == "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS")
          elif name == "ORB_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'ORB_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "ORB_LISTENER_ADDRESS")
          elif name == "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'SAS_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS")
          else:
            Log.log("Warning: Invalid attribute name " + name + " specified for WebSphereOverlayEndpoint. Expected " +
            "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS, CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS, " +
            "ORB_LISTENER_ADDRESS or SAS_SSL_SERVERAUTH_LISTENER_ADDRESS.");
        '''
  Util.popPathElement('ObjectRequestBroker');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ObjectRequestBroker')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectRequestBroker resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.locaterequesttimeout", None), "locateRequestTimeout","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.forcetunnel", None), "forceTunnel","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.nolocalcopies", None), "noLocalCopies","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.requestretriescount", None), "requestRetriesCount","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.enable", None), "enable","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.connectioncacheminimum", None), "connectionCacheMinimum","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.connectioncachemaximum", None), "connectionCacheMaximum","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.requestretriesdelay", None), "requestRetriesDelay","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.commtraceenabled", None), "commTraceEnabled","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.tunnelagenturl", None), "tunnelAgentURL","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.useserverthreadpool", None), "useServerThreadPool","ObjectRequestBroker");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectrequestbroker.requesttimeout", None), "requestTimeout","ObjectRequestBroker");
  if len(atts) != 0:
    print "Modifying ObjectRequestBroker with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ObjectRequestBroker configuration up to date.";

  Property.removeProperties(objid, 'properties',"ObjectRequestBroker");

  interceptors = Util.parseConfigIdListAttribute(objid, 'interceptors',"ObjectRequestBroker");
  for interceptor in interceptors:
    if len(interceptor) > 0:
      Util.remove(interceptor);

  lsdConnection = Util.getOptionalAttribute(objid, 'lsdConnection', 'ObjectRequestBroker');
  if lsdConnection is not None and len(lsdConnection) > 0:
    Util.remove(lsdConnection);

  plugins = Util.parseConfigIdListAttribute(objid, 'plugins',"ObjectRequestBroker");
  for plugin in plugins:
    if len(plugin) > 0:
      Util.remove(plugin);

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'ObjectRequestBroker');
  if threadPool is not None and len(threadPool) > 0:
    Util.remove(threadPool);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereInterceptor":
          Interceptor.create(objid, curjsonobject);
        elif currole == "WebSphereLSDConnection":
          LSDConnection.create(objid, curjsonobject);
        elif currole == "WebSphereORBPlugin":
          ORBPlugin.create(objid, curjsonobject);
        elif currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
        elif currole == "WebSphereEndPoint":
          name = curjsonobject.getString('name');
          if name == "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject)
            else:
              createEndPoint(objid, curjsonobject, "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS");
          elif name == "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject);
            else:
              createEndPoint(objid, curjsonobject, "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS");
          elif name == "ORB_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'ORB_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject);
            else:
              createEndPoint(objid, curjsonobject, "ORB_LISTENER_ADDRESS");
          elif name == "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS":
            ep = Util.getOptionalAttribute(objid, 'SAS_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if ep is not None and len(ep) > 0:
              EndPoint.update(ep, curjsonobject);
            else:
              createEndPoint(objid, curjsonobject, "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS");
          else:
            Log.log("Warning: Invalid attribute name " + name + " specified for WebSphereEndPoint. Expected " +
            "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS, CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS, " +
            "ORB_LISTENER_ADDRESS or SAS_SSL_SERVERAUTH_LISTENER_ADDRESS.");
        '''
        ITS NOT POSSIBLE FROM WHAT I CAN TELL
        elif currole == "WebSphereOverlayEndpoint":
          name = curjsonobject.getString('name');
          if name == "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS")
          elif name == "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS")
          elif name == "ORB_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'ORB_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "ORB_LISTENER_ADDRESS")
          elif name == "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS":
            oep = Util.getOptionalAttribute(objid, 'SAS_SSL_SERVERAUTH_LISTENER_ADDRESS', 'ObjectRequestBroker');
            if oep is not None and len(oep) > 0:
              OverlayEndpoint.update(oep, curjsonobject);
            else:
              OverlayEndpoint.create(objid, curjsonobject, "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS")
          else:
            Log.log("Warning: Invalid attribute name " + name + " specified for WebSphereOverlayEndpoint. Expected " +
            "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS, CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS, " +
            "ORB_LISTENER_ADDRESS or SAS_SSL_SERVERAUTH_LISTENER_ADDRESS.");
        '''
  Util.popPathElement('ObjectRequestBroker');
