from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('QueueTimeGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereQueueTimeGoal");
  exportedObject.put("roleName", "WebSphereQueueTimeGoal");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.importance", objid, "importance","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.goalvalue", objid, "goalValue","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.timeperiodvalueunits", objid, "timePeriodValueUnits","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.violationenabled", objid, "violationEnabled","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.goaldeltavalueunits", objid, "goalDeltaValueUnits","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.goalvalueunits", objid, "goalValueUnits","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.goaldeltavalue", objid, "goalDeltaValue","QueueTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.queuetimegoal.timeperiodvalue", objid, "timePeriodValue","QueueTimeGoal");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('QueueTimeGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('QueueTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("QueueTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "importance", roleProperties.optString("websphere.queuetimegoal.importance", None));
  Util.addIfNotNone(properties, "goalValue", roleProperties.optString("websphere.queuetimegoal.goalvalue", None));
  Util.addIfNotNone(properties, "timePeriodValueUnits", roleProperties.optString("websphere.queuetimegoal.timeperiodvalueunits", None));
  Util.addIfNotNone(properties, "violationEnabled", roleProperties.optString("websphere.queuetimegoal.violationenabled", None));
  Util.addIfNotNone(properties, "goalDeltaValueUnits", roleProperties.optString("websphere.queuetimegoal.goaldeltavalueunits", None));
  Util.addIfNotNone(properties, "goalValueUnits", roleProperties.optString("websphere.queuetimegoal.goalvalueunits", None));
  Util.addIfNotNone(properties, "goalDeltaValue", roleProperties.optString("websphere.queuetimegoal.goaldeltavalue", None));
  Util.addIfNotNone(properties, "timePeriodValue", roleProperties.optString("websphere.queuetimegoal.timeperiodvalue", None));
  print "Creating QueueTimeGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("QueueTimeGoal", parentid, properties);
  Util.popPathElement('QueueTimeGoal');

def update(objid,jsonobject):
  Util.pushPathElement('QueueTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("QueueTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.importance", None), "importance","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.goalvalue", None), "goalValue","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.timeperiodvalueunits", None), "timePeriodValueUnits","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.violationenabled", None), "violationEnabled","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.goaldeltavalueunits", None), "goalDeltaValueUnits","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.goalvalueunits", None), "goalValueUnits","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.goaldeltavalue", None), "goalDeltaValue","QueueTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.queuetimegoal.timeperiodvalue", None), "timePeriodValue","QueueTimeGoal");
  if len(atts) != 0:
    print "Modifying QueueTimeGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "QueueTimeGoal configuration up to date.";

  Util.popPathElement('QueueTimeGoal');
