from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from J2EEResourceProperty import J2EEResourceProperty
from AdminObjectRef import AdminObjectRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AdminObjectTemplateProps')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAdminObjectTemplateProps");
  exportedObject.put("roleName", "WebSphereAdminObjectTemplateProps");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  resourceProperties = Util.parseConfigIdListAttribute(objid, 'properties', 'AdminObjectTemplateProps');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      returndict = Util.createTypeFolder(respath, "J2EEResourceProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, J2EEResourceProperty._export(resprop, currespath));

  adminObject = Util.getOptionalAttribute(objid, 'adminObject', 'AdminObjectTemplateProps');
  if adminObject is not None and len(adminObject) > 0:
    returndict = Util.createTypeFolder(respath, "AdminObjectRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    adminObjectName = Util.getRequiredAttribute(adminObject, "adminObjectClass", "AdminObject" );
    Util.addAllFromExport(extraObjects, AdminObjectRef._export(adminObject, currespath, adminObjectName));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AdminObjectTemplateProps');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AdminObjectTemplateProps')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminObjectTemplateProps resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating AdminObjectTemplateProps with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AdminObjectTemplateProps", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereAdminObjectRef":
        AdminObjectRef.doImport(objid, curjsonobject);
  Util.popPathElement('AdminObjectTemplateProps');

def update(objid,jsonobject):
  Util.pushPathElement('AdminObjectTemplateProps')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminObjectTemplateProps resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying AdminObjectTemplateProps with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AdminObjectTemplateProps configuration up to date.";

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'properties', 'AdminObjectTemplateProps');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereAdminObjectRef":
        AdminObjectRef.doImport(objid, curjsonobject);
  Util.popPathElement('AdminObjectTemplateProps');
