from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "ConnectionPool";

  containmentpath = "%(parentconpath)sConnectionPool:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConnectionPool')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConnectionPool");
  exportedObject.put("roleName", "WebSphereConnectionPool");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.stuckthreshold", objid, "stuckThreshold","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.unusedtimeout", objid, "unusedTimeout","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.maxconnections", objid, "maxConnections","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.stucktimertime", objid, "stuckTimerTime","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.testconnectioninterval", objid, "testConnectionInterval","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.minconnections", objid, "minConnections","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.surgethreshold", objid, "surgeThreshold","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.connectiontimeout", objid, "connectionTimeout","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.purgepolicy", objid, "purgePolicy","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.surgecreationinterval", objid, "surgeCreationInterval","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.numberofunsharedpoolpartitions", objid, "numberOfUnsharedPoolPartitions","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.stucktime", objid, "stuckTime","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.agedtimeout", objid, "agedTimeout","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.reaptime", objid, "reapTime","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.testconnection", objid, "testConnection","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.numberofsharedpoolpartitions", objid, "numberOfSharedPoolPartitions","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.freepooldistributiontablesize", objid, "freePoolDistributionTableSize","ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connectionpool.numberoffreepoolpartitions", objid, "numberOfFreePoolPartitions","ConnectionPool");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ConnectionPool");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConnectionPool');
  return result;

def create(parentid, jsonobject, attname = ""):
  Util.pushPathElement('ConnectionPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "stuckThreshold", roleProperties.optString("websphere.connectionpool.stuckthreshold", None));
  Util.addIfNotNone(properties, "unusedTimeout", roleProperties.optString("websphere.connectionpool.unusedtimeout", None));
  Util.addIfNotNone(properties, "maxConnections", roleProperties.optString("websphere.connectionpool.maxconnections", None));
  Util.addIfNotNone(properties, "stuckTimerTime", roleProperties.optString("websphere.connectionpool.stucktimertime", None));
  Util.addIfNotNone(properties, "testConnectionInterval", roleProperties.optString("websphere.connectionpool.testconnectioninterval", None));
  Util.addIfNotNone(properties, "minConnections", roleProperties.optString("websphere.connectionpool.minconnections", None));
  Util.addIfNotNone(properties, "surgeThreshold", roleProperties.optString("websphere.connectionpool.surgethreshold", None));
  Util.addIfNotNone(properties, "connectionTimeout", roleProperties.optString("websphere.connectionpool.connectiontimeout", None));
  Util.addIfNotNone(properties, "purgePolicy", roleProperties.optString("websphere.connectionpool.purgepolicy", None));
  Util.addIfNotNone(properties, "surgeCreationInterval", roleProperties.optString("websphere.connectionpool.surgecreationinterval", None));
  Util.addIfNotNone(properties, "numberOfUnsharedPoolPartitions", roleProperties.optString("websphere.connectionpool.numberofunsharedpoolpartitions", None));
  Util.addIfNotNone(properties, "stuckTime", roleProperties.optString("websphere.connectionpool.stucktime", None));
  Util.addIfNotNone(properties, "agedTimeout", roleProperties.optString("websphere.connectionpool.agedtimeout", None));
  Util.addIfNotNone(properties, "reapTime", roleProperties.optString("websphere.connectionpool.reaptime", None));
  Util.addIfNotNone(properties, "testConnection", roleProperties.optString("websphere.connectionpool.testconnection", None));
  Util.addIfNotNone(properties, "numberOfSharedPoolPartitions", roleProperties.optString("websphere.connectionpool.numberofsharedpoolpartitions", None));
  Util.addIfNotNone(properties, "freePoolDistributionTableSize", roleProperties.optString("websphere.connectionpool.freepooldistributiontablesize", None));
  Util.addIfNotNone(properties, "numberOfFreePoolPartitions", roleProperties.optString("websphere.connectionpool.numberoffreepoolpartitions", None));
  print "Creating ConnectionPool with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  if attname != None and len(attname) > 0:
    objid = Util.create("ConnectionPool", parentid, properties, attname);
  else:
    objid = Util.create("ConnectionPool", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ConnectionPool');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ConnectionPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.stuckthreshold", None), "stuckThreshold","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.unusedtimeout", None), "unusedTimeout","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.maxconnections", None), "maxConnections","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.stucktimertime", None), "stuckTimerTime","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.testconnectioninterval", None), "testConnectionInterval","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.minconnections", None), "minConnections","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.surgethreshold", None), "surgeThreshold","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.connectiontimeout", None), "connectionTimeout","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.purgepolicy", None), "purgePolicy","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.surgecreationinterval", None), "surgeCreationInterval","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.numberofunsharedpoolpartitions", None), "numberOfUnsharedPoolPartitions","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.stucktime", None), "stuckTime","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.agedtimeout", None), "agedTimeout","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.reaptime", None), "reapTime","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.testconnection", None), "testConnection","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.numberofsharedpoolpartitions", None), "numberOfSharedPoolPartitions","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.freepooldistributiontablesize", None), "freePoolDistributionTableSize","ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connectionpool.numberoffreepoolpartitions", None), "numberOfFreePoolPartitions","ConnectionPool");
  if len(atts) != 0:
    print "Modifying ConnectionPool with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConnectionPool configuration up to date.";

  Property.removeProperties(objid, 'properties',"ConnectionPool");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('ConnectionPool');
