from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('IPSprayer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIPSprayer");
  exportedObject.put("roleName", "WebSphereIPSprayer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ipsprayer.port", objid, "port","IPSprayer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ipsprayer.isenabled", objid, "isEnabled","IPSprayer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ipsprayer.host", objid, "host","IPSprayer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"IPSprayer");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('IPSprayer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('IPSprayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("IPSprayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.ipsprayer.port", None));
  Util.addIfNotNone(properties, "isEnabled", roleProperties.optString("websphere.ipsprayer.isenabled", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.ipsprayer.host", None));
  print "Creating IPSprayer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("IPSprayer", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('IPSprayer');

def update(objid,jsonobject):
  Util.pushPathElement('IPSprayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("IPSprayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ipsprayer.port", None), "port","IPSprayer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ipsprayer.isenabled", None), "isEnabled","IPSprayer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ipsprayer.host", None), "host","IPSprayer");
  if len(atts) != 0:
    print "Modifying IPSprayer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "IPSprayer configuration up to date.";

  Property.removeProperties(objid, 'properties',"IPSprayer");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('IPSprayer');
