from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQLinkReceiverChannel')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQLinkReceiverChannel");
  exportedObject.put("roleName", "WebSphereSIBMQLinkReceiverChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinkreceiverchannel.inboundpersistentreliability", objid, "inboundPersistentReliability","SIBMQLinkReceiverChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinkreceiverchannel.receiverchannelname", objid, "receiverChannelName","SIBMQLinkReceiverChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinkreceiverchannel.receiverchannelinitialstate", objid, "receiverChannelInitialState","SIBMQLinkReceiverChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinkreceiverchannel.inboundnonpersistentreliability", objid, "inboundNonPersistentReliability","SIBMQLinkReceiverChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQLinkReceiverChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQLinkReceiverChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkReceiverChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundPersistentReliability", roleProperties.optString("websphere.sibmqlinkreceiverchannel.inboundpersistentreliability", None));
  Util.addIfNotNone(properties, "receiverChannelName", roleProperties.optString("websphere.sibmqlinkreceiverchannel.receiverchannelname", None));
  Util.addIfNotNone(properties, "receiverChannelInitialState", roleProperties.optString("websphere.sibmqlinkreceiverchannel.receiverchannelinitialstate", None));
  Util.addIfNotNone(properties, "inboundNonPersistentReliability", roleProperties.optString("websphere.sibmqlinkreceiverchannel.inboundnonpersistentreliability", None));
  print "Creating SIBMQLinkReceiverChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQLinkReceiverChannel", parentid, properties);
  Util.popPathElement('SIBMQLinkReceiverChannel');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQLinkReceiverChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkReceiverChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinkreceiverchannel.inboundpersistentreliability", None), "inboundPersistentReliability","SIBMQLinkReceiverChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinkreceiverchannel.receiverchannelname", None), "receiverChannelName","SIBMQLinkReceiverChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinkreceiverchannel.receiverchannelinitialstate", None), "receiverChannelInitialState","SIBMQLinkReceiverChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinkreceiverchannel.inboundnonpersistentreliability", None), "inboundNonPersistentReliability","SIBMQLinkReceiverChannel");
  if len(atts) != 0:
    print "Modifying SIBMQLinkReceiverChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQLinkReceiverChannel configuration up to date.";

  Util.popPathElement('SIBMQLinkReceiverChannel');
