from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Action')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAction");
  exportedObject.put("roleName", "WebSphereAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.action.name", objid, "name","Action");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.action.priority", objid, "priority","Action");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.action.type", objid, "type","Action");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.action.value", objid, "value","Action");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.action.continue", objid, "continue","Action");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Action");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Action');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Action')
  if not jsonobject.has("roleProperties"):
    raise Exception("Action resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.action.name", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.action.priority", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.action.type", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.action.value", None));
  Util.addIfNotNone(properties, "continue", roleProperties.optString("websphere.action.continue", None));
  print "Creating Action with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Action", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Action');


def update(objid,jsonobject):
  Util.pushPathElement('Action')
  if not jsonobject.has("roleProperties"):
    raise Exception("Action resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.action.name", None), "name","Action");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.action.priority", None), "priority","Action");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.action.type", None), "type","Action");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.action.value", None), "value","Action");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.action.continue", None), "continue","Action");
  if len(atts) != 0:
    print "Modifying Action with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Action configuration up to date.";

  Property.removeProperties(objid, 'properties',"Action");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Action');
