###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from SSLConfigRef import SSLConfigRef
from AuthMechanism import AuthMechanism
from JAASAuthData import JAASAuthData
from KeyStore import KeyStore
from SSLConfig import SSLConfig
from SSLConfigGroup import SSLConfigGroup
from Certificate import Certificate
from CACertificate import CACertificate
from LDAPUserRegistry import LDAPUserRegistry
from LocalOSUserRegistry import LocalOSUserRegistry
from CustomUserRegistry import CustomUserRegistry
from WIMUserRegistry import WIMUserRegistry
from UserRegistryRef import UserRegistryRef
from TrustedAuthenticationRealm import TrustedAuthenticationRealm
from WSSchedule import WSSchedule

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AppSecurity')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAppSecurity");
  exportedObject.put("roleName", "WebSphereAppSecurity");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.allowbasicauth", objid, "allowBasicAuth","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.uselocalsecurityserver", objid, "useLocalSecurityServer","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.usedomainqualifiedusernames", objid, "useDomainQualifiedUserNames","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.enabled", objid, "enabled","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.cachetimeout", objid, "cacheTimeout","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.enforcefinegrainedjcasecurity", objid, "enforceFineGrainedJCASecurity","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.enablejava2secruntimefiltering", objid, "enableJava2SecRuntimeFiltering","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.enforcejava2security", objid, "enforceJava2Security","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.allowallpermissionforapplication", objid, "allowAllPermissionForApplication","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.appenabled", objid, "appEnabled","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.dynamicallyupdatesslconfig", objid, "dynamicallyUpdateSSLConfig","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.activeprotocol", objid, "activeProtocol","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.internalserverid", objid, "internalServerId","AppSecurity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.appsecurity.issuepermissionwarning", objid, "issuePermissionWarning","AppSecurity");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AppSecurity");
  extraObjects = AuthMechanism.exportAuthMechanisms(objid, respath, extraObjects, typeFolders, 'authMechanisms', "AppSecurity", "AuthMechanism");

  defaultSSLSettings = Util.getOptionalAttribute(objid, 'defaultSSLSettings', 'AppSecurity');
  if defaultSSLSettings is not None and len(defaultSSLSettings) > 0:
    returndict = Util.createTypeFolder(respath, "SSLConfigRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SSLConfigRef._export(defaultSSLSettings, currespath, "DefaultSSLSettings"));

  i = 0;
  cai = 0;
  certificates = Util.parseConfigIdListAttribute(objid, 'certificates',"AppSecurity");
  for certificate in certificates:
    if len(certificate) > 0:
      returndict = Util.createTypeFolder(respath, "Certificate", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      if certificate.find("#Certificate_") != -1:
        Util.addAllFromExport(extraObjects, Certificate._export(certificate, currespath, "Certificate%s" % i));
        i = i + 1;
      elif certificate.find("#CACertificate_") != -1:
        Util.addAllFromExport(extraObjects, CACertificate._export(certificate, currespath, "CACertificate%s" % cai));
        cai = cai + 1;

  i = 0;
  jaasAuthDatas = Util.parseConfigIdListAttribute(objid, 'authDataEntries', "AppSecurity");
  for jaasAuthData in jaasAuthDatas:
    if len(jaasAuthData) > 0:
      returndict = Util.createTypeFolder(respath, "JAASAuthData", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, JAASAuthData._export(jaasAuthData, currespath, Util.getRequiredAttribute(jaasAuthData, 'alias', 'JAASAuthData').replace("/","-")));
      i = i + 1;

  i = 0;
  wsSchedules = Util.parseConfigIdListAttribute(objid, 'wsSchedules', "AppSecurity");
  for wsSchedule in wsSchedules:
    if len(wsSchedule) > 0:
      returndict = Util.createTypeFolder(respath, "WSSchedule", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, WSSchedule._export(wsSchedule, currespath, "WSSchedule_AppSec%s" % i));
      i = i + 1;

  i = 0;
  keyStores = Util.parseConfigIdListAttribute(objid, 'keyStores', "AppSecurity");
  for keyStore in keyStores:
    if len(keyStore) > 0:
      returndict = Util.createTypeFolder(respath, "KeyStore", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      # KeyStore names are not unique
      Util.addAllFromExport(extraObjects, KeyStore._export(keyStore, currespath, "KeyStore%s" % i));
      i = i + 1;

  i = 0;
  repertoires = Util.parseConfigIdListAttribute(objid, 'repertoire', "AppSecurity");
  for repertoire in repertoires:
    if len(repertoire) > 0:
      returndict = Util.createTypeFolder(respath, "SSLConfig", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SSLConfig._export(repertoire, currespath, "SSLConfig%s" % i));
      i = i + 1;

  i = 0;
  sslConfigGroups = Util.parseConfigIdListAttribute(objid, 'sslConfigGroups', "AppSecurity");
  for sslConfigGroup in sslConfigGroups:
    if len(sslConfigGroup) > 0:
      returndict = Util.createTypeFolder(respath, "SSLConfigGroup", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SSLConfigGroup._export(sslConfigGroup, currespath, "SSLConfigGroup%s" % i));
      i = i + 1;

  i = 0;
  ldapUserRegistries = LDAPUserRegistry.getLDAPUserRegistry(objid);
  for ldapUserRegistry in ldapUserRegistries:
    if len(ldapUserRegistry) > 0:
      returndict = Util.createTypeFolder(respath, "LDAPUserRegistry", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, LDAPUserRegistry._export(ldapUserRegistry, currespath, "LDAP User Registry%s" % i));
      i = i + 1;

  i = 0;
  localOSUserRegistries = LocalOSUserRegistry.getLocalOSUserRegistry(objid);
  for localOSUserRegistry in localOSUserRegistries:
    if len(localOSUserRegistry) > 0:
      returndict = Util.createTypeFolder(respath, "LocalOSUserRegistry", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, LocalOSUserRegistry._export(localOSUserRegistry, currespath, "Local OS User Registry%s" % i));
      i = i + 1;

  i = 0;
  customUserRegistries = CustomUserRegistry.getCustomUserRegistry(objid);
  for customUserRegistry in customUserRegistries:
    if customUserRegistry is not None and len(customUserRegistry) > 0:
      returndict = Util.createTypeFolder(respath, "CustomUserRegistry", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, CustomUserRegistry._export(customUserRegistry, currespath, "Custom User Registry%s" % i));
      i = i + 1;

  i = 0;
  wimUserRegistries = WIMUserRegistry.getWIMUserRegistry(objid);
  for wimUserRegistry in wimUserRegistries:
    if wimUserRegistry is not None and len(wimUserRegistry) > 0:
      returndict = Util.createTypeFolder(respath, "WIMUserRegistry", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, WIMUserRegistry._export(wimUserRegistry, currespath, "WIM User Registry%s" % i));
      i = i + 1;

  activeUserRegistry = Util.getOptionalAttribute(objid, 'activeUserRegistry', 'AppSecurity');
  if activeUserRegistry is not None and len(activeUserRegistry) > 0:
    returndict = Util.createTypeFolder(respath, "UserRegistryRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    type = "";
    if activeUserRegistry.find("#LDAPUserRegistry_") != -1:
      type = "LDAPUserRegistry";
    elif activeUserRegistry.find("#LocalOSUserRegistry_") != -1:
      type = "LocalOSUserRegistry";
    elif activeUserRegistry.find("#CustomUserRegistry_") != -1:
      type = "CustomUserRegistry";
    elif activeUserRegistry.find("#WIMUserRegistry_") != -1:
      type = "WIMUserRegistry";
    realm = "";
    realm = Util.getOptionalAttribute(activeUserRegistry, 'realm', "UserRegistry");
    Util.addAllFromExport(extraObjects, UserRegistryRef._export(activeUserRegistry, currespath, type, realm, type + " - " + realm));

  inbound = Util.getOptionalAttribute(objid, 'inboundTrustedAuthenticationRealm',"AppSecurity");
  if inbound is not None and len(inbound) > 0:
    returndict = Util.createTypeFolder(respath, "TrustedAuthenticationRealm", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, TrustedAuthenticationRealm._export(inbound, currespath, "inboundTrustedAuthenticationRealm"));

  outbound = Util.getOptionalAttribute(objid, 'outboundTrustedAuthenticationRealm',"AppSecurity");
  if outbound is not None and len(outbound) > 0:
    returndict = Util.createTypeFolder(respath, "TrustedAuthenticationRealm", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, TrustedAuthenticationRealm._export(outbound, currespath, "outboundTrustedAuthenticationRealm"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AppSecurity');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AppSecurity')
  if not jsonobject.has("roleProperties"):
    raise Exception("AppSecurity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "allowBasicAuth", roleProperties.optString("websphere.appsecurity.allowbasicauth", None));
  Util.addIfNotNone(properties, "useLocalSecurityServer", roleProperties.optString("websphere.appsecurity.uselocalsecurityserver", None));
  Util.addIfNotNone(properties, "useDomainQualifiedUserNames", roleProperties.optString("websphere.appsecurity.usedomainqualifiedusernames", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.appsecurity.enabled", None));
  Util.addIfNotNone(properties, "cacheTimeout", roleProperties.optString("websphere.appsecurity.cachetimeout", None));
  Util.addIfNotNone(properties, "enforceFineGrainedJCASecurity", roleProperties.optString("websphere.appsecurity.enforcefinegrainedjcasecurity", None));
  Util.addIfNotNone(properties, "enableJava2SecRuntimeFiltering", roleProperties.optString("websphere.appsecurity.enablejava2secruntimefiltering", None));
  Util.addIfNotNone(properties, "enforceJava2Security", roleProperties.optString("websphere.appsecurity.enforcejava2security", None));
  Util.addIfNotNone(properties, "allowAllPermissionForApplication", roleProperties.optString("websphere.appsecurity.allowallpermissionforapplication", None));
  Util.addIfNotNone(properties, "appEnabled", roleProperties.optString("websphere.appsecurity.appenabled", None));
  Util.addIfNotNone(properties, "dynamicallyUpdateSSLConfig", roleProperties.optString("websphere.appsecurity.dynamicallyupdatesslconfig", None));
  Util.addIfNotNone(properties, "activeProtocol", roleProperties.optString("websphere.appsecurity.activeprotocol", None));
  Util.addIfNotNone(properties, "internalServerId", roleProperties.optString("websphere.appsecurity.internalserverid", None));
  Util.addIfNotNone(properties, "issuePermissionWarning", roleProperties.optString("websphere.appsecurity.issuepermissionwarning", None));
  print "Creating AppSecurity with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AppSecurity", parentid, properties);

  jaasAuthDatas = Util.parseConfigIdListAttribute(objid, 'authDataEntries', "Security");
  for jaasAuthData in jaasAuthDatas:
    if len(jaasAuthData) > 0:
      Util.remove(jaasAuthData);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 1:
        continue;
      authObject = AuthMechanism.createObjIfRole(objid, curjsonobject, currole);
      if (authObject == 1):
        continue;
      if currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "defaultSSLSettings");
      elif currole == "WebSphereJAASAuthData":
        JAASAuthData.create(objid, curjsonobject);
      elif currole == "WebSphereKeyStore":
        KeyStore.create(objid, curjsonobject);
      elif currole == "WebSphereSSLConfig":
        SSLConfig.create(objid, curjsonobject, "repertoire");
      elif currole == "WebSphereSSLConfigGroup":
        SSLConfigGroup.create(objid, curjsonobject);
      elif currole == "WebSphereCertificate":
        Certificate.create(objid, curjsonobject);
      elif currole == "WebSphereCACertificate":
        CACertificate.create(objid, curjsonobject);
      elif currole == "WebSphereLDAPUserRegistry":
        LDAPUserRegistry.create(objid, curjsonobject);
      elif currole == "WebSphereWIMUserRegistry":
        WIMUserRegistry.create(objid, curjsonobject);
      elif currole == "WebSphereLocalOSUserRegistry":
        LocalOSUserRegistry.create(objid, curjsonobject);
      elif currole == "WebSphereWSSchedule":
        WSSchedule.create(objid, curjsonobject);
      elif currole == "WebSphereCustomUserRegistry":
        CustomUserRegistry.create(objid, curjsonobject);
      elif (currole == "WebSphereTrustedAuthenticationRealm") and (curjsonobject.getString("name") == "inboundTrustedAuthenticationRealm"):
        TrustedAuthenticationRealm.create(objid, curjsonobject, 'inboundTrustedAuthenticationRealm');
      elif (currole == "WebSphereTrustedAuthenticationRealm") and (curjsonobject.getString("name") == "outboundTrustedAuthenticationRealm"):
        TrustedAuthenticationRealm.create(objid, curjsonobject, 'outboundTrustedAuthenticationRealm');

  # Must create UserRegistryRef after creating User Registries
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereUserRegistryRef":
        UserRegistryRef.doImport(objid, curjsonobject);
  Util.popPathElement('AppSecurity');



def update(objid,jsonobject):
  Util.pushPathElement('AppSecurity')
  if not jsonobject.has("roleProperties"):
    raise Exception("AppSecurity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.allowbasicauth", None), "allowBasicAuth","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.uselocalsecurityserver", None), "useLocalSecurityServer","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.usedomainqualifiedusernames", None), "useDomainQualifiedUserNames","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.enabled", None), "enabled","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.cachetimeout", None), "cacheTimeout","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.enforcefinegrainedjcasecurity", None), "enforceFineGrainedJCASecurity","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.enablejava2secruntimefiltering", None), "enableJava2SecRuntimeFiltering","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.enforcejava2security", None), "enforceJava2Security","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.allowallpermissionforapplication", None), "allowAllPermissionForApplication","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.appenabled", None), "appEnabled","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.dynamicallyupdatesslconfig", None), "dynamicallyUpdateSSLConfig","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.activeprotocol", None), "activeProtocol","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.internalserverid", None), "internalServerId","AppSecurity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.appsecurity.issuepermissionwarning", None), "issuePermissionWarning","AppSecurity");
  if len(atts) != 0:
    print "Modifying AppSecurity with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "AppSecurity configuration up to date.";

  Property.removeProperties(objid, 'properties',"AppSecurity");
  Util.unsetAttribute(objid, "defaultSSLSettings", "AppSecurity");

  jaasAuthDatas = Util.parseConfigIdListAttribute(objid, 'authDataEntries', "Security");
  for jaasAuthData in jaasAuthDatas:
    if len(jaasAuthData) > 0:
      Util.remove(jaasAuthData);

  repertoires = Util.parseConfigIdListAttribute(objid, 'repertoire', "Security");
  for repertoire in repertoires:
    Util.remove(repertoire);

  sslConfigGroups = Util.parseConfigIdListAttribute(objid, 'sslConfigGroups', "Security");
  for sslConfigGroup in sslConfigGroups:
    Util.remove(sslConfigGroup);

  wsSchedules = Util.parseConfigIdListAttribute(objid, 'wsSchedules', "AppSecurity");
  for wsSchedule in wsSchedules:
    Util.remove(wsSchedule);

  # Cannot delete KeyStores.  We can only update them because we are corrupting the password
  # field when we try to create them.

  certificates = Util.parseConfigIdListAttribute(objid, 'certificates',"AppSecurity");
  for certificate in certificates:
    if len(certificate) > 0:
      if certificate.find("#CACertificate_") != -1:
        Util.remove(certificate);

  inbound = Util.getOptionalAttribute(objid, 'inboundTrustedAuthenticationRealm',"AppSecurity");
  if inbound is not None and len(inbound) > 0:
    Util.remove(inbound);

  outbound = Util.getOptionalAttribute(objid, 'outboundTrustedAuthenticationRealm',"AppSecurity");
  if outbound is not None and len(outbound) > 0:
    Util.remove(outbound);

  # Must create WSSchedule next so that references can be created later.
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereWSSchedule":
        WSSchedule.create(objid, curjsonobject);

  # Must create KeyStores first so that references can be created later.
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereKeyStore":
        keyStoreToUpdate = KeyStore.find(objid, curjsonobject);
        if keyStoreToUpdate is not None or len(keyStoreToUpdate) > 0:
          KeyStore.update(keyStoreToUpdate, curjsonobject);
        else:
          KeyStore.create(objid, curjsonobject);

  # Must create SSLConfigs next so that references can be created later.
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfig":
        SSLConfig.create(objid, curjsonobject, "repertoire");

  # Must create User Registries so that references can be created later
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereLDAPUserRegistry":
        LDAPUserRegistry.update(objid, curjsonobject);
      elif currole == "WebSphereLocalOSUserRegistry":
        LocalOSUserRegistry.update(objid, curjsonobject);
      elif currole == "WebSphereCustomUserRegistry":
        CustomUserRegistry.update(objid, curjsonobject);
      elif currole == "WebSphereWIMUserRegistry":
        WIMUserRegistry.update(objid, curjsonobject);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 1:
        continue;
      authObject = AuthMechanism.updateObjIfRole(objid, curjsonobject, currole, "AppSecurity");
      if (authObject == 1):
        continue;
      if currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "defaultSSLSettings");
      elif currole == "WebSphereJAASAuthData":
        JAASAuthData.create(objid, curjsonobject);
      elif currole == "WebSphereSSLConfigGroup":
        SSLConfigGroup.create(objid, curjsonobject);
      elif currole == "WebSphereCertificate":
        certificateToUpdate = Certificate.find(objid, curjsonobject);
        if certificateToUpdate is not None or len(certificateToUpdate) > 0:
          Certificate.update(certificateToUpdate, curjsonobject);
      elif currole == "WebSphereCACertificate":
        CACertificate.create(objid, curjsonobject);
      elif currole == "WebSphereUserRegistryRef":
        UserRegistryRef.doImport(objid, curjsonobject);
      elif (currole == "WebSphereTrustedAuthenticationRealm") and (curjsonobject.getString("name") == "inboundTrustedAuthenticationRealm"):
        TrustedAuthenticationRealm.create(objid, curjsonobject, 'inboundTrustedAuthenticationRealm');
      elif (currole == "WebSphereTrustedAuthenticationRealm") and (curjsonobject.getString("name") == "outboundTrustedAuthenticationRealm"):
        TrustedAuthenticationRealm.create(objid, curjsonobject, 'outboundTrustedAuthenticationRealm');
  Util.popPathElement('AppSecurity');

def getAppSecurity(objid):
  appSecurity = Util.getAssociatedObjects(objid, "AppSecurity");
  return appSecurity;

