from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationClientFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationClientFile");
  exportedObject.put("roleName", "WebSphereApplicationClientFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationclientfile.lastmodified", objid, "lastModified","ApplicationClientFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationclientfile.originaluri", objid, "originalURI","ApplicationClientFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.applicationclientfile.types", objid, "types","ApplicationClientFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationclientfile.directoryentry", objid, "directoryEntry","ApplicationClientFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationclientfile.uri", objid, "URI","ApplicationClientFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationclientfile.size", objid, "size","ApplicationClientFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "ApplicationClientFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationClientFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationClientFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationClientFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.applicationclientfile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.applicationclientfile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.applicationclientfile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.applicationclientfile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.applicationclientfile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.applicationclientfile.size", None));
  print "Creating ApplicationClientFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationClientFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ApplicationClientFile');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationClientFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationClientFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationclientfile.lastmodified", None), "lastModified","ApplicationClientFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationclientfile.originaluri", None), "originalURI","ApplicationClientFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationclientfile.types", None), "types","ApplicationClientFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationclientfile.directoryentry", None), "directoryEntry","ApplicationClientFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationclientfile.uri", None), "URI","ApplicationClientFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationclientfile.size", None), "size","ApplicationClientFile");
  if len(atts) != 0:
    print "Modifying ApplicationClientFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationClientFile configuration up to date.";

  File.removeFiles(objid, 'files',"ApplicationClientFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ApplicationClientFile');
