from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DeploymentTargetMapping import DeploymentTargetMapping
from Property import Property
from Classloader import Classloader

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ClientModuleDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClientModuleDeployment");
  exportedObject.put("roleName", "WebSphereClientModuleDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientmoduledeployment.name", objid, "name","ClientModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientmoduledeployment.startingweight", objid, "startingWeight","ClientModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientmoduledeployment.uri", objid, "uri","ClientModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientmoduledeployment.deploymentid", objid, "deploymentId","ClientModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clientmoduledeployment.altdd", objid, "altDD","ClientModuleDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  i = 0;
  typeFolders = {};
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"ClientModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      returndict = Util.createTypeFolder(respath, "DeploymentTargetMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DeploymentTargetMapping._export(targetmapping, currespath, "DeploymentTargetMapping%s" % i));
      i = i + 1;
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ClientModuleDeployment");
  
  classloader = Util.getRequiredAttribute(objid, 'classloader',"ClientModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    returndict = Util.createTypeFolder(respath, "Classloader", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, Classloader._export(classloader, currespath, "Classloader"));
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ClientModuleDeployment');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('ClientModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClientModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.clientmoduledeployment.name", None));
  Util.addIfNotNone(properties, "startingWeight", roleProperties.optString("websphere.clientmoduledeployment.startingweight", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.clientmoduledeployment.uri", None));
  Util.addIfNotNone(properties, "deploymentId", roleProperties.optString("websphere.clientmoduledeployment.deploymentid", None));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.clientmoduledeployment.altdd", None));
  print "Creating ClientModuleDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ClientModuleDeployment", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);      
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ClientModuleDeployment');


def update(objid,jsonobject):
  Util.pushPathElement('ClientModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClientModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientmoduledeployment.name", None), "name","ClientModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientmoduledeployment.startingweight", None), "startingWeight","ClientModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientmoduledeployment.uri", None), "uri","ClientModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientmoduledeployment.deploymentid", None), "deploymentId","ClientModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clientmoduledeployment.altdd", None), "altDD","ClientModuleDeployment");
  if len(atts) != 0:
    print "Modifying ClientModuleDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ClientModuleDeployment configuration up to date.";

  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"ClientModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      Util.remove(targetmapping);
   
  classloader = Util.getRequiredAttribute(objid, 'classloader',"ClientModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    Util.remove(classloader);

  Property.removeProperties(objid, 'properties',"ClientModuleDeployment");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);      
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ClientModuleDeployment');
