from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EmailNotifications')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEmailNotifications");
  exportedObject.put("roleName", "WebSphereEmailNotifications");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emailnotifications.transportuserid", objid, "transportUserId","EmailNotifications");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emailnotifications.transporthostname", objid, "transportHostName","EmailNotifications");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emailnotifications.port", objid, "port","EmailNotifications");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.emailnotifications.emailaddresses", objid, "emailAddresses","EmailNotifications");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emailnotifications.enabled", objid, "enabled","EmailNotifications");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emailnotifications.transportpassword", objid, "transportPassword","EmailNotifications");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EmailNotifications');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EmailNotifications')
  if not jsonobject.has("roleProperties"):
    raise Exception("EmailNotifications resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "transportUserId", roleProperties.optString("websphere.emailnotifications.transportuserid", None));
  Util.addIfNotNone(properties, "transportHostName", roleProperties.optString("websphere.emailnotifications.transporthostname", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.emailnotifications.port", None));
  Util.addPathProperty(properties, "emailAddresses", roleProperties.optString("websphere.emailnotifications.emailaddresses", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.emailnotifications.enabled", None));
  Util.addIfNotNone(properties, "transportPassword", roleProperties.optString("websphere.emailnotifications.transportpassword", None));
  print "Creating EmailNotifications with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EmailNotifications", parentid, properties);
  Util.popPathElement('EmailNotifications');

def update(objid,jsonobject):
  Util.pushPathElement('EmailNotifications')
  if not jsonobject.has("roleProperties"):
    raise Exception("EmailNotifications resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emailnotifications.transportuserid", None), "transportUserId","EmailNotifications");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emailnotifications.transporthostname", None), "transportHostName","EmailNotifications");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emailnotifications.port", None), "port","EmailNotifications");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.emailnotifications.emailaddresses", None), "emailAddresses","EmailNotifications");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emailnotifications.enabled", None), "enabled","EmailNotifications");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emailnotifications.transportpassword", None), "transportPassword","EmailNotifications");
  if len(atts) != 0:
    print "Modifying EmailNotifications with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EmailNotifications configuration up to date.";

  Util.popPathElement('EmailNotifications');
