from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericServerCluster')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericServerCluster");
  exportedObject.put("roleName", "WebSphereGenericServerCluster");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.name", objid, "name","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.outboundsslalias", objid, "outboundSSLAlias","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.cacheinstancename", objid, "cacheInstanceName","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.sslcacheenable", objid, "sslCacheEnable","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.connectionpoolenable", objid, "connectionPoolEnable","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.maxconnectionsperserver", objid, "maxConnectionsPerServer","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.cacheupdateuri", objid, "cacheUpdateUri","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.enablecaching", objid, "enableCaching","GenericServerCluster");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericservercluster.protocol", objid, "protocol","GenericServerCluster");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"GenericServerCluster");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericServerCluster');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericServerCluster')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerCluster resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.genericservercluster.name", None));
  Util.addIfNotNone(properties, "outboundSSLAlias", roleProperties.optString("websphere.genericservercluster.outboundsslalias", None));
  Util.addIfNotNone(properties, "cacheInstanceName", roleProperties.optString("websphere.genericservercluster.cacheinstancename", None));
  Util.addIfNotNone(properties, "sslCacheEnable", roleProperties.optString("websphere.genericservercluster.sslcacheenable", None));
  Util.addIfNotNone(properties, "connectionPoolEnable", roleProperties.optString("websphere.genericservercluster.connectionpoolenable", None));
  Util.addIfNotNone(properties, "maxConnectionsPerServer", roleProperties.optString("websphere.genericservercluster.maxconnectionsperserver", None));
  Util.addIfNotNone(properties, "cacheUpdateUri", roleProperties.optString("websphere.genericservercluster.cacheupdateuri", None));
  Util.addIfNotNone(properties, "enableCaching", roleProperties.optString("websphere.genericservercluster.enablecaching", None));
  Util.addIfNotNone(properties, "protocol", roleProperties.optString("websphere.genericservercluster.protocol", None));
  print "Creating GenericServerCluster with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericServerCluster", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericServerCluster');

def update(objid,jsonobject):
  Util.pushPathElement('GenericServerCluster')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerCluster resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.name", None), "name","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.outboundsslalias", None), "outboundSSLAlias","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.cacheinstancename", None), "cacheInstanceName","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.sslcacheenable", None), "sslCacheEnable","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.connectionpoolenable", None), "connectionPoolEnable","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.maxconnectionsperserver", None), "maxConnectionsPerServer","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.cacheupdateuri", None), "cacheUpdateUri","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.enablecaching", None), "enableCaching","GenericServerCluster");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericservercluster.protocol", None), "protocol","GenericServerCluster");
  if len(atts) != 0:
    print "Modifying GenericServerCluster with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericServerCluster configuration up to date.";

  Property.removeProperties(objid, 'properties',"GenericServerCluster");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericServerCluster');
