###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from Property import Property
from InjectionTarget import InjectionTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PersistenceContextRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePersistenceContextRef");
  exportedObject.put("roleName", "WebSpherePersistenceContextRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.persistencecontextref.persistencecontexttype", objid, "persistenceContextType","PersistenceContextRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.persistencecontextref.name", objid, "name","PersistenceContextRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.persistencecontextref.mappedname", objid, "mappedName","PersistenceContextRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.persistencecontextref.persistenceunitname", objid, "persistenceUnitName","PersistenceContextRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"PersistenceContextRef");
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'PersistenceContextRef');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'PersistenceContextRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      returndict = Util.createTypeFolder(respath, "InjectionTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      injName = Util.getOptionalAttribute(injTarget, "injectionTargetName", "InjectionTarget");
      if injName is not None and len(injName) > 0:
        resourceName = injName;
      else:
        resourceName = "InjectionTarget%s" % i;
      Util.addAllFromExport(extraObjects, InjectionTarget._export(injTarget, currespath, resourceName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PersistenceContextRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PersistenceContextRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("PersistenceContextRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "persistenceContextType", roleProperties.optString("websphere.persistencecontextref.persistencecontexttype", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.persistencecontextref.name", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.persistencecontextref.mappedname", None));
  Util.addIfNotNone(properties, "persistenceUnitName", roleProperties.optString("websphere.persistencecontextref.persistenceunitname", None));
  print "Creating PersistenceContextRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PersistenceContextRef", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PersistenceContextRef');

def update(objid,jsonobject):
  Util.pushPathElement('PersistenceContextRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("PersistenceContextRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.persistencecontextref.persistencecontexttype", None), "persistenceContextType","PersistenceContextRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.persistencecontextref.name", None), "name","PersistenceContextRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.persistencecontextref.mappedname", None), "mappedName","PersistenceContextRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.persistencecontextref.persistenceunitname", None), "persistenceUnitName","PersistenceContextRef");
  if len(atts) != 0:
    print "Modifying PersistenceContextRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PersistenceContextRef configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'PersistenceContextRef');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'PersistenceContextRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      Util.remove(injTarget);

  Property.removeProperties(objid, 'properties',"PersistenceContextRef");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PersistenceContextRef');
