from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PrimaryAdminExt')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePrimaryAdminExt");
  exportedObject.put("roleName", "WebSpherePrimaryAdminExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.primaryadminext.name", objid, "name","PrimaryAdminExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.primaryadminext.accessid", objid, "accessId","PrimaryAdminExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PrimaryAdminExt');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('PrimaryAdminExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("PrimaryAdminExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.primaryadminext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.primaryadminext.accessid", None));
  print "Creating PrimaryAdminExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PrimaryAdminExt", parentid, properties, attName);
  Util.popPathElement('PrimaryAdminExt');

def update(objid,jsonobject):
  Util.pushPathElement('PrimaryAdminExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("PrimaryAdminExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.primaryadminext.name", None), "name","PrimaryAdminExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.primaryadminext.accessid", None), "accessId","PrimaryAdminExt");
  if len(atts) != 0:
    print "Modifying PrimaryAdminExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PrimaryAdminExt configuration up to date.";

  Util.popPathElement('PrimaryAdminExt');
