from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from RewritingRule import RewritingRule

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RewritingPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRewritingPolicy");
  exportedObject.put("roleName", "WebSphereRewritingPolicy");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  rewritingRules = Util.parseConfigIdListAttribute(objid, 'rewritingRules',"RewritingPolicy");
  for rewritingRule in rewritingRules:
    if len(rewritingRule) > 0:
      returndict = Util.createTypeFolder(respath, "RewritingRule", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, RewritingRule._export(rewritingRule, currespath, "Rewriting Rule%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RewritingPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RewritingPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("RewritingPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating RewritingPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RewritingPolicy", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereRewritingRule":
        RewritingRule.create(objid, curjsonobject);
  Util.popPathElement('RewritingPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('RewritingPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("RewritingPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying RewritingPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RewritingPolicy configuration up to date.";

  rewritingRules = Util.parseConfigIdListAttribute(objid, 'rewritingRules', "RewritingPolicy");
  for rewritingRule in rewritingRules:
    if len(rewritingRule) > 0:
      Util.remove(rewritingRule);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereRewritingRule":
        RewritingRule.create(objid, curjsonobject);

  Util.popPathElement('RewritingPolicy');
