from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Rule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRule");
  exportedObject.put("roleName", "WebSphereRule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rule.name", objid, "name","Rule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rule.priority", objid, "priority","Rule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rule.expression", objid, "expression","Rule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Rule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Rule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Rule')
  if not jsonobject.has("roleProperties"):
    raise Exception("Rule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.rule.name", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.rule.priority", None));
  Util.addIfNotNone(properties, "expression", roleProperties.optString("websphere.rule.expression", None));
  print "Creating Rule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Rule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Rule');

def update(objid,jsonobject):
  Util.pushPathElement('Rule')
  if not jsonobject.has("roleProperties"):
    raise Exception("Rule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rule.name", None), "name","Rule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rule.priority", None), "priority","Rule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rule.expression", None), "expression","Rule");
  if len(atts) != 0:
    print "Modifying Rule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Rule configuration up to date.";

  Property.removeProperties(objid, 'properties',"Rule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Rule');
