from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQLinkSenderChannelLocalizationPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQLinkSenderChannelLocalizationPoint");
  exportedObject.put("roleName", "WebSphereSIBMQLinkSenderChannelLocalizationPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannellocalizationpoint.identifier", objid, "identifier","SIBMQLinkSenderChannelLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannellocalizationpoint.highmessagethreshold", objid, "highMessageThreshold","SIBMQLinkSenderChannelLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannellocalizationpoint.targetuuid", objid, "targetUuid","SIBMQLinkSenderChannelLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannellocalizationpoint.sendallowed", objid, "sendAllowed","SIBMQLinkSenderChannelLocalizationPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQLinkSenderChannelLocalizationPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQLinkSenderChannelLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkSenderChannelLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.identifier", None));
  Util.addIfNotNone(properties, "highMessageThreshold", roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.highmessagethreshold", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.targetuuid", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.sendallowed", None));
  print "Creating SIBMQLinkSenderChannelLocalizationPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQLinkSenderChannelLocalizationPoint", parentid, properties);
  Util.popPathElement('SIBMQLinkSenderChannelLocalizationPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQLinkSenderChannelLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkSenderChannelLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.identifier", None), "identifier","SIBMQLinkSenderChannelLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.highmessagethreshold", None), "highMessageThreshold","SIBMQLinkSenderChannelLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.targetuuid", None), "targetUuid","SIBMQLinkSenderChannelLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannellocalizationpoint.sendallowed", None), "sendAllowed","SIBMQLinkSenderChannelLocalizationPoint");
  if len(atts) != 0:
    print "Modifying SIBMQLinkSenderChannelLocalizationPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQLinkSenderChannelLocalizationPoint configuration up to date.";

  Util.popPathElement('SIBMQLinkSenderChannelLocalizationPoint');
