from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBMediationInstance import SIBMediationInstance

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMediationLocalizationPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMediationLocalizationPoint");
  exportedObject.put("roleName", "WebSphereSIBMediationLocalizationPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationlocalizationpoint.identifier", objid, "identifier","SIBMediationLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationlocalizationpoint.highmessagethreshold", objid, "highMessageThreshold","SIBMediationLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationlocalizationpoint.uuid", objid, "uuid","SIBMediationLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationlocalizationpoint.targetuuid", objid, "targetUuid","SIBMediationLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationlocalizationpoint.sendallowed", objid, "sendAllowed","SIBMediationLocalizationPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  mediationInstance = Util.getOptionalAttribute(objid, 'mediationInstance', "SIBMediationLocalizationPoint");
  if (mediationInstance is not None) and (len(mediationInstance) > 0):
    returndict = Util.createTypeFolder(respath, "SIBMediationInstance", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBMediationInstance._export(mediationInstance, currespath, "SIBMediationInstance"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMediationLocalizationPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMediationLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediationLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibmediationlocalizationpoint.identifier", None));
  Util.addIfNotNone(properties, "highMessageThreshold", roleProperties.optString("websphere.sibmediationlocalizationpoint.highmessagethreshold", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmediationlocalizationpoint.uuid", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibmediationlocalizationpoint.targetuuid", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibmediationlocalizationpoint.sendallowed", None));
  print "Creating SIBMediationLocalizationPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMediationLocalizationPoint", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMediationInstance":
        SIBMediationInstance.create(objid, curjsonobject);
  Util.popPathElement('SIBMediationLocalizationPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMediationLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediationLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationlocalizationpoint.identifier", None), "identifier","SIBMediationLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationlocalizationpoint.highmessagethreshold", None), "highMessageThreshold","SIBMediationLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationlocalizationpoint.uuid", None), "uuid","SIBMediationLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationlocalizationpoint.targetuuid", None), "targetUuid","SIBMediationLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationlocalizationpoint.sendallowed", None), "sendAllowed","SIBMediationLocalizationPoint");
  if len(atts) != 0:
    print "Modifying SIBMediationLocalizationPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMediationLocalizationPoint configuration up to date.";

  mediationInstance = Util.getOptionalAttribute(objid, 'mediationInstance', "SIBMediationLocalizationPoint");
  if (mediationInstance is not None) and (len(mediationInstance) > 0):
    Util.remove(mediationInstance);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMediationInstance":
        SIBMediationInstance.create(objid, curjsonobject);
  Util.popPathElement('SIBMediationLocalizationPoint');
